/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.device;

import com.android.bundle.Devices;
import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.device.AbiMatcher;
import com.android.tools.build.bundletool.device.LanguageMatcher;
import com.android.tools.build.bundletool.device.ScreenDensityMatcher;
import com.android.tools.build.bundletool.device.SdkVersionMatcher;

public class ApkMatcher {
    private final SdkVersionMatcher sdkVersionMatcher;
    private final AbiMatcher abiMatcher;
    private final ScreenDensityMatcher screenDensityMatcher;
    private final LanguageMatcher languageMatcher;

    public ApkMatcher(Devices.DeviceSpec deviceSpec) {
        this.sdkVersionMatcher = new SdkVersionMatcher(deviceSpec);
        this.abiMatcher = new AbiMatcher(deviceSpec);
        this.screenDensityMatcher = new ScreenDensityMatcher(deviceSpec);
        this.languageMatcher = new LanguageMatcher(deviceSpec);
    }

    public boolean matchesApk(Devices.ApkMatchingMetadata apkMatchingMetadata) {
        return this.matchesVariantTargeting(apkMatchingMetadata) && this.matchesApkTargeting(apkMatchingMetadata);
    }

    private boolean matchesVariantTargeting(Devices.ApkMatchingMetadata apkMatchingMetadata) {
        Targeting.VariantTargeting variantTargeting = apkMatchingMetadata.getVariantTargeting();
        return this.sdkVersionMatcher.getVariantTargetingPredicate().and(this.abiMatcher.getVariantTargetingPredicate()).and(this.screenDensityMatcher.getVariantTargetingPredicate()).test(variantTargeting);
    }

    private boolean matchesApkTargeting(Devices.ApkMatchingMetadata apkMatchingMetadata) {
        Targeting.ApkTargeting apkTargeting = apkMatchingMetadata.getApkTargeting();
        return this.sdkVersionMatcher.getApkTargetingPredicate().and(this.abiMatcher.getApkTargetingPredicate()).and(this.screenDensityMatcher.getApkTargetingPredicate()).and(this.languageMatcher.getApkTargetingPredicate()).test(apkTargeting);
    }
}

