/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.io;

import com.android.tools.build.bundletool.io.AutoValue_ZipBuilder_Entry;
import com.android.tools.build.bundletool.io.ZipPath;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.ByteStreams;
import com.google.protobuf.MessageLite;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public final class ZipBuilder {
    private final Map<ZipPath, Entry> entries = new LinkedHashMap<ZipPath, Entry>();

    public Path writeTo(Path target) throws IOException {
        Path tempFile = Files.createTempFile("ZipBuilder-", ".zip.tmp", new FileAttribute[0]);
        try {
            try (ZipOutputStream outZip = new ZipOutputStream(new FileOutputStream(tempFile.toFile()));){
                for (ZipPath path : this.entries.keySet()) {
                    Throwable throwable;
                    ZipEntry zipEntry;
                    Entry entry = this.entries.get(path);
                    InputStreamSupplier inputStreamSupplier = entry.getIsDirectory() ? () -> new ByteArrayInputStream(new byte[0]) : entry.getInputStreamSupplier().get();
                    if (entry.getIsDirectory()) {
                        zipEntry = new ZipEntry(path + "/");
                    } else {
                        zipEntry = new ZipEntry(path.toString());
                        if (entry.hasOption(EntryOption.UNCOMPRESSED)) {
                            zipEntry.setMethod(0);
                            throwable = null;
                            try (InputStream is = entry.getInputStreamSupplier().get().get();){
                                byte[] entryData = ByteStreams.toByteArray((InputStream)is);
                                zipEntry.setSize(entryData.length);
                                zipEntry.setCompressedSize(entryData.length);
                                zipEntry.setCrc(ZipBuilder.computeCrc32(entryData));
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                        }
                    }
                    InputStream content = inputStreamSupplier.get();
                    throwable = null;
                    try {
                        outZip.putNextEntry(zipEntry);
                        ByteStreams.copy((InputStream)content, (OutputStream)outZip);
                        outZip.closeEntry();
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (content == null) continue;
                        if (throwable != null) {
                            try {
                                content.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        content.close();
                    }
                }
            }
            Files.move(tempFile, target, new CopyOption[0]);
        }
        catch (IOException e) {
            Files.deleteIfExists(tempFile);
            throw e;
        }
        return target;
    }

    public ZipBuilder addFileWithContent(ZipPath toPath, byte[] content, EntryOption ... options) {
        return this.addFile(toPath, () -> new ByteArrayInputStream(content), options);
    }

    public ZipBuilder addFileFromDisk(ZipPath toPath, File file, EntryOption ... options) {
        Preconditions.checkArgument((boolean)file.isFile(), (String)"Path '%s' does not denote a file.", (Object)file);
        return this.addFile(toPath, () -> new BufferedInputStream(new FileInputStream(file)), options);
    }

    public ZipBuilder addFileWithProtoContent(ZipPath toPath, MessageLite protoMsg, EntryOption ... options) {
        return this.addFile(toPath, () -> new ByteArrayInputStream(protoMsg.toByteArray()), options);
    }

    public ZipBuilder addFileFromZip(ZipPath toPath, ZipFile fromZipFile, ZipEntry zipEntry, EntryOption ... options) {
        return this.addFile(toPath, () -> fromZipFile.getInputStream(zipEntry), options);
    }

    public ZipBuilder addFile(ZipPath toPath, InputStreamSupplier inputStreamSupplier, EntryOption ... options) {
        Preconditions.checkArgument((!this.entries.containsKey(toPath) ? 1 : 0) != 0, (String)"Path '%s' is already taken.", (Object)toPath);
        this.entries.put(toPath, Entry.builder().setIsDirectory(false).setInputStreamSupplier(inputStreamSupplier).setOptions((ImmutableSet<EntryOption>)ImmutableSet.copyOf((Object[])options)).build());
        return this;
    }

    public ZipBuilder addDirectory(ZipPath dir) {
        Preconditions.checkArgument((!this.entries.containsKey(dir) ? 1 : 0) != 0, (String)"Path '%s' is already taken.", (Object)dir);
        this.entries.put(dir, Entry.builder().setIsDirectory(true).setOptions((ImmutableSet<EntryOption>)ImmutableSet.of()).build());
        return this;
    }

    public ZipBuilder copyAllContentsFromZip(ZipPath toDirectory, ZipFile srcZipFile) {
        Enumeration<? extends ZipEntry> zipEntries = srcZipFile.entries();
        while (zipEntries.hasMoreElements()) {
            ZipEntry zipEntry = zipEntries.nextElement();
            if (zipEntry.isDirectory()) continue;
            this.addFileFromZip(toDirectory.resolve(zipEntry.getName()), srcZipFile, zipEntry, new EntryOption[0]);
        }
        return this;
    }

    private static long computeCrc32(byte[] data) {
        CRC32 crc32 = new CRC32();
        crc32.update(data);
        return crc32.getValue();
    }

    public static enum EntryOption {
        UNCOMPRESSED;

    }

    @AutoValue
    protected static abstract class Entry {
        protected Entry() {
        }

        public abstract Optional<InputStreamSupplier> getInputStreamSupplier();

        public abstract boolean getIsDirectory();

        public abstract ImmutableSet<EntryOption> getOptions();

        public static Builder builder() {
            return new AutoValue_ZipBuilder_Entry.Builder();
        }

        public boolean hasOption(EntryOption option) {
            return this.getOptions().contains((Object)option);
        }

        static abstract class Builder {
            Builder() {
            }

            public abstract Builder setInputStreamSupplier(InputStreamSupplier var1);

            public abstract Builder setIsDirectory(boolean var1);

            public abstract Builder setOptions(ImmutableSet<EntryOption> var1);

            public abstract Entry autoBuild();

            public Entry build() {
                Entry result = this.autoBuild();
                Preconditions.checkState((boolean)(result.getInputStreamSupplier().isPresent() ^ result.getIsDirectory()), (Object)"Input stream supplier must be absent iff the entry is a directory.");
                return result;
            }
        }
    }

    public static interface InputStreamSupplier {
        public InputStream get() throws IOException;
    }
}

