/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.validation;

import com.android.tools.build.bundletool.exceptions.ValidationException;
import com.android.tools.build.bundletool.io.ZipUtils;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.BundleModuleName;
import com.android.tools.build.bundletool.model.ModuleZipEntry;
import com.android.tools.build.bundletool.utils.files.FilePreconditions;
import com.android.tools.build.bundletool.validation.AbiParityValidator;
import com.android.tools.build.bundletool.validation.AndroidManifestValidator;
import com.android.tools.build.bundletool.validation.BundleFilesValidator;
import com.android.tools.build.bundletool.validation.EntryClashValidator;
import com.android.tools.build.bundletool.validation.ModuleDependencyValidator;
import com.android.tools.build.bundletool.validation.ResourceTableValidator;
import com.android.tools.build.bundletool.validation.SubValidator;
import com.android.tools.build.bundletool.validation.ValidatorRunner;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.io.MoreFiles;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class BundleModulesValidator {
    private static final ImmutableList<SubValidator> MODULES_SUB_VALIDATORS = ImmutableList.of((Object)new BundleFilesValidator(), (Object)new AndroidManifestValidator(), (Object)new EntryClashValidator(), (Object)new AbiParityValidator(), (Object)new ModuleDependencyValidator(), (Object)new ResourceTableValidator());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate(ImmutableList<Path> modulePaths) {
        FilePreconditions.checkFileNamesAreUnique("Modules", modulePaths);
        HashMap<Path, ZipFile> zipFileByPath = new HashMap<Path, ZipFile>();
        try {
            for (Path modulePath : modulePaths) {
                FilePreconditions.checkFileHasExtension("Module", modulePath, ".zip");
                zipFileByPath.put(modulePath, ZipUtils.openZipFile(modulePath));
            }
            ImmutableList modules = (ImmutableList)zipFileByPath.entrySet().stream().map(entry -> this.toBundleModule((Path)entry.getKey(), (ZipFile)entry.getValue())).collect(ImmutableList.toImmutableList());
            new ValidatorRunner(MODULES_SUB_VALIDATORS).validate((ImmutableList<BundleModule>)modules);
        }
        finally {
            if (zipFileByPath != null) {
                ZipUtils.closeZipFiles(zipFileByPath.values());
            }
        }
    }

    private BundleModule toBundleModule(Path modulePath, ZipFile moduleZipFile) {
        BundleModuleName moduleName = BundleModuleName.create(MoreFiles.getNameWithoutExtension((Path)modulePath));
        try {
            return BundleModule.builder().setName(moduleName).addEntries((Collection)moduleZipFile.stream().filter((Predicate<? extends ZipEntry>)Predicates.not(ZipEntry::isDirectory)).map(zipEntry -> ModuleZipEntry.fromModuleZipEntry(zipEntry, moduleZipFile)).collect(ImmutableList.toImmutableList())).build();
        }
        catch (IOException e) {
            throw ValidationException.builder().withCause(e).withMessage("Error reading module zip file '%s'.", modulePath).build();
        }
    }
}

