/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.regalloc;

import java.util.Map;
import java.util.Set;
import shadow.bundletool.com.android.tools.r8.code.MoveType;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;

public class RegisterMove
implements Comparable<RegisterMove> {
    MoveType type;
    int dst;
    int src;
    Instruction definition;

    public RegisterMove(int dst, int src, MoveType type) {
        this.dst = dst;
        this.src = src;
        this.type = type;
    }

    public RegisterMove(int dst, MoveType type, Instruction definition) {
        this.dst = dst;
        this.src = Integer.MIN_VALUE;
        this.type = type;
        assert (definition.isConstInstruction() || definition.isArgument());
        this.definition = definition;
    }

    private boolean writes(int register) {
        if (this.type == MoveType.WIDE && this.dst + 1 == register) {
            return true;
        }
        return this.dst == register;
    }

    public boolean isBlocked(Set<RegisterMove> moveSet, Map<Integer, Integer> valueMap) {
        for (RegisterMove move : moveSet) {
            if (move.src == Integer.MIN_VALUE || move == this) continue;
            if (this.writes(valueMap.get(move.src))) {
                return true;
            }
            if (move.type != MoveType.WIDE || !this.writes(valueMap.get(move.src) + 1)) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.src + this.dst * 3 + this.type.hashCode() * 5 + (this.definition == null ? 0 : this.definition.hashCode());
    }

    public boolean equals(Object other) {
        if (!(other instanceof RegisterMove)) {
            return false;
        }
        RegisterMove o = (RegisterMove)other;
        return o.src == this.src && o.dst == this.dst && o.type == this.type && o.definition == this.definition;
    }

    @Override
    public int compareTo(RegisterMove o) {
        int srcDiff = this.src - o.src;
        if (srcDiff != 0) {
            return srcDiff;
        }
        int dstDiff = this.dst - o.dst;
        if (dstDiff != 0) {
            return dstDiff;
        }
        int typeDiff = o.type.ordinal() - this.type.ordinal();
        if (typeDiff != 0) {
            return typeDiff;
        }
        if (this.definition == null) {
            if (o.definition != null) {
                return -1;
            }
            return 0;
        }
        if (o.definition == null) {
            return 1;
        }
        return this.definition.getNumber() - o.definition.getNumber();
    }
}

