/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.utils;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.nio.file.Path;
import java.util.Map;
import shadow.bundletool.com.android.tools.r8.errors.CompilationError;
import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.naming.ClassNameMapper;

public class DescriptorUtils {
    public static final char DESCRIPTOR_PACKAGE_SEPARATOR = '/';
    public static final char JAVA_PACKAGE_SEPARATOR = '.';
    private static final Map<String, String> typeNameToLetterMap = ImmutableMap.builder().put((Object)"void", (Object)"V").put((Object)"boolean", (Object)"Z").put((Object)"byte", (Object)"B").put((Object)"short", (Object)"S").put((Object)"char", (Object)"C").put((Object)"int", (Object)"I").put((Object)"long", (Object)"J").put((Object)"float", (Object)"F").put((Object)"double", (Object)"D").build();

    private static String internalToDescriptor(String typeName, boolean shorty, boolean ignorePrimitives) {
        String descriptor = null;
        if (!ignorePrimitives) {
            descriptor = typeNameToLetterMap.get(typeName);
        }
        if (descriptor != null) {
            return descriptor;
        }
        if (shorty) {
            return "L";
        }
        if (typeName.endsWith("[]")) {
            return "[" + DescriptorUtils.internalToDescriptor(typeName.substring(0, typeName.length() - 2), shorty, ignorePrimitives);
        }
        return "L" + typeName.replace('.', '/') + ";";
    }

    public static String javaTypeToDescriptor(String typeName) {
        assert (typeName.indexOf(47) == -1);
        return DescriptorUtils.internalToDescriptor(typeName, false, false);
    }

    public static String javaTypeToDescriptorIgnorePrimitives(String typeName) {
        assert (typeName.indexOf(47) == -1);
        return DescriptorUtils.internalToDescriptor(typeName, false, true);
    }

    public static String javaTypeToDescriptorIfValidJavaType(String typeName) {
        if (DescriptorUtils.isValidJavaType(typeName)) {
            return DescriptorUtils.javaTypeToDescriptor(typeName);
        }
        return null;
    }

    public static boolean isValidJavaType(String typeName) {
        if (typeName.length() == 0) {
            return false;
        }
        char last = '\u0000';
        for (int i = 0; i < typeName.length(); ++i) {
            char c = typeName.charAt(i);
            if (c == ';' || c == '[' || c == '/') {
                return false;
            }
            if (c == '.' && (i == 0 || last == '.')) {
                return false;
            }
            last = c;
        }
        return true;
    }

    public static String javaTypeToShorty(String typeName) {
        return DescriptorUtils.internalToDescriptor(typeName, true, false);
    }

    public static String descriptorToJavaType(String descriptor) {
        return DescriptorUtils.descriptorToJavaType(descriptor, null);
    }

    public static String descriptorToJavaType(String descriptor, ClassNameMapper classNameMapper) {
        switch (descriptor.charAt(0)) {
            case 'L': {
                assert (descriptor.charAt(descriptor.length() - 1) == ';');
                String clazz = descriptor.substring(1, descriptor.length() - 1).replace('/', '.');
                String originalName = classNameMapper == null ? clazz : classNameMapper.deobfuscateClassName(clazz);
                return originalName;
            }
            case '[': {
                return DescriptorUtils.descriptorToJavaType(descriptor.substring(1, descriptor.length()), classNameMapper) + "[]";
            }
            case 'V': {
                return "void";
            }
            case 'Z': {
                return "boolean";
            }
            case 'B': {
                return "byte";
            }
            case 'S': {
                return "short";
            }
            case 'C': {
                return "char";
            }
            case 'I': {
                return "int";
            }
            case 'J': {
                return "long";
            }
            case 'F': {
                return "float";
            }
            case 'D': {
                return "double";
            }
        }
        throw new Unreachable("Unknown type " + descriptor);
    }

    public static String getSimpleClassNameFromDescriptor(String classDescriptor) {
        return DescriptorUtils.getSimpleClassNameFromBinaryName(DescriptorUtils.getClassBinaryNameFromDescriptor(classDescriptor));
    }

    public static String getClassNameFromDescriptor(String classDescriptor) {
        return DescriptorUtils.getClassBinaryNameFromDescriptor(classDescriptor).replace('/', '.');
    }

    public static String getPackageNameFromDescriptor(String descriptor) {
        return DescriptorUtils.getPackageNameFromBinaryName(DescriptorUtils.getClassBinaryNameFromDescriptor(descriptor));
    }

    public static String getClassBinaryNameFromDescriptor(String classDescriptor) {
        assert (DescriptorUtils.isClassDescriptor(classDescriptor)) : "Invalid class descriptor " + classDescriptor;
        return classDescriptor.substring(1, classDescriptor.length() - 1);
    }

    public static String getPackageBinaryNameFromJavaType(String packageName) {
        return packageName.replace('.', '/');
    }

    public static String getDescriptorFromClassBinaryName(String typeBinaryName) {
        return 'L' + typeBinaryName + ';';
    }

    public static String getSimpleClassNameFromBinaryName(String classBinaryName) {
        int simpleNameIndex = classBinaryName.lastIndexOf(47);
        return simpleNameIndex < 0 ? classBinaryName : classBinaryName.substring(simpleNameIndex + 1);
    }

    public static boolean isClassDescriptor(String descriptor) {
        char ch;
        char[] buffer = descriptor.toCharArray();
        int length = buffer.length;
        if (length < 3 || buffer[0] != 'L') {
            return false;
        }
        int pos = 1;
        do {
            if (pos >= length) {
                return false;
            }
            if (DescriptorUtils.isInvalidChar(ch = buffer[pos++]) || ch == '/' || ch == ';') {
                return false;
            }
            do {
                if (pos >= length) {
                    return false;
                }
                if (!DescriptorUtils.isInvalidChar(ch = buffer[pos++])) continue;
                return false;
            } while (ch != '/' && ch != ';');
        } while (ch != ';');
        return pos == length;
    }

    public static String getPackageNameFromBinaryName(String classBinaryName) {
        int nameIndex = classBinaryName.lastIndexOf(47);
        return nameIndex < 0 ? "" : classBinaryName.substring(0, nameIndex).replace('/', '.');
    }

    private static boolean isInvalidChar(char ch) {
        switch (ch) {
            case '.': 
            case '[': {
                return true;
            }
        }
        return false;
    }

    public static String guessTypeDescriptor(Path name) {
        return DescriptorUtils.guessTypeDescriptor(name.toString());
    }

    public static String guessTypeDescriptor(String name) {
        assert (name != null);
        assert (name.endsWith(".class")) : "Name " + name + " must have " + ".class" + " suffix";
        String fileName = File.separatorChar == '/' ? name.toString() : name.toString().replace(File.separatorChar, '/');
        String descriptor = fileName.substring(0, fileName.length() - ".class".length());
        if (descriptor.contains(".")) {
            throw new CompilationError("Unexpected class file name: " + fileName);
        }
        return 'L' + descriptor + ';';
    }

    public static String getPathFromDescriptor(String descriptor) {
        assert (descriptor.startsWith("L"));
        assert (descriptor.endsWith(";"));
        return descriptor.substring(1, descriptor.length() - 1) + ".class";
    }

    public static String getPathFromJavaType(String typeName) {
        assert (DescriptorUtils.isValidJavaType(typeName));
        return typeName.replace(".", "/") + ".class";
    }
}

