/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool;

import com.android.tools.build.bundletool.commands.BuildApksCommand;
import com.android.tools.build.bundletool.commands.BuildBundleCommand;
import com.android.tools.build.bundletool.commands.GetDeviceSpecCommand;
import com.android.tools.build.bundletool.commands.SelectApksCommand;
import com.android.tools.build.bundletool.commands.ValidateBundleCommand;
import com.android.tools.build.bundletool.commands.VersionCommand;
import com.android.tools.build.bundletool.utils.EnvironmentVariableProvider;
import com.android.tools.build.bundletool.utils.flags.FlagParser;
import com.android.tools.build.bundletool.utils.flags.ParsedFlags;
import com.android.tools.build.bundletool.version.BundleToolVersion;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class BundleToolMain {
    public static final String HELP_CMD = "help";

    public static void main(String[] args) {
        BundleToolMain.main(args, Runtime.getRuntime());
    }

    static void main(String[] args, Runtime runtime) {
        ParsedFlags flags;
        try {
            flags = new FlagParser().parse(args);
        }
        catch (FlagParser.FlagParseException e) {
            System.out.println("Error while parsing the flags: " + e.getMessage());
            runtime.exit(1);
            return;
        }
        List<String> commands = flags.getCommands();
        if (commands.isEmpty()) {
            System.out.println("Error: You have to specify a command.");
            BundleToolMain.help();
            runtime.exit(1);
            return;
        }
        try {
            switch (commands.get(0)) {
                case "build-bundle": {
                    BuildBundleCommand.fromFlags(flags).execute();
                    break;
                }
                case "build-apks": {
                    BuildApksCommand.fromFlags(flags, EnvironmentVariableProvider.DEFAULT_PROVIDER).execute();
                    break;
                }
                case "get-device-spec": {
                    GetDeviceSpecCommand.fromFlags(flags).execute();
                    break;
                }
                case "validate": {
                    ValidateBundleCommand.fromFlags(flags).execute();
                    break;
                }
                case "select-apks": {
                    SelectApksCommand.fromFlags(flags).execute();
                    break;
                }
                case "version": {
                    VersionCommand.fromFlags(flags, System.out).execute();
                    break;
                }
                case "help": {
                    if (commands.size() > 1) {
                        BundleToolMain.help(commands.get(1));
                    } else {
                        BundleToolMain.help();
                    }
                    return;
                }
                default: {
                    System.out.printf("Error: Unrecognized command '%s'.%n", commands.get(0));
                    BundleToolMain.help();
                    runtime.exit(1);
                    break;
                }
            }
        }
        catch (Exception e) {
            System.out.println("[BT:" + BundleToolVersion.getCurrentVersion() + "] Error: " + e.getMessage());
            e.printStackTrace(System.out);
            runtime.exit(1);
        }
    }

    public static void help() {
        System.out.printf("bundletool [%s] ...%n", BundleToolMain.joinOptions("build-bundle", "build-apks", "select-apks", "validate", "version", HELP_CMD));
        System.out.println("Use 'bundletool help <command>' to learn more about the given command.");
    }

    public static void help(String commandName) {
        switch (commandName) {
            case "build-bundle": {
                BuildBundleCommand.help();
                break;
            }
            case "build-apks": {
                BuildApksCommand.help();
                break;
            }
            case "get-device-spec": {
                GetDeviceSpecCommand.help();
                break;
            }
            case "select-apks": {
                SelectApksCommand.help();
                break;
            }
            case "validate": {
                ValidateBundleCommand.help();
                break;
            }
            default: {
                System.out.printf("Error: Unrecognized command '%s'.%n", commandName);
                BundleToolMain.help();
            }
        }
    }

    private static String joinOptions(String ... options) {
        return Arrays.stream(options).collect(Collectors.joining("|"));
    }
}

