/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.commands;

import com.android.bundle.Commands;
import com.android.bundle.Devices;
import com.android.tools.build.bundletool.commands.AutoValue_SelectApksCommand;
import com.android.tools.build.bundletool.commands.CommandHelp;
import com.android.tools.build.bundletool.device.ApkMatcher;
import com.android.tools.build.bundletool.device.ApkMatchingMetadataUtils;
import com.android.tools.build.bundletool.exceptions.CommandExecutionException;
import com.android.tools.build.bundletool.utils.files.FilePreconditions;
import com.android.tools.build.bundletool.utils.flags.Flag;
import com.android.tools.build.bundletool.utils.flags.ParsedFlags;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.ByteStreams;
import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

@AutoValue
public abstract class SelectApksCommand {
    public static final String COMMAND_NAME = "select-apks";
    private static final Flag<Path> APKS_ARCHIVE_FILE_FLAG = Flag.path("apks");
    private static final Flag<Path> DEVICE_SPEC_FLAG = Flag.path("device-spec");
    private static final Flag<Path> OUTPUT_DIRECTORY = Flag.path("output");
    private static final String PB_JSON = ".pb.json";
    private static final String PB = ".pb";

    public abstract Path getApksArchivePath();

    public abstract Devices.DeviceSpec getDeviceSpec();

    public abstract Path getOutputDirectory();

    public static Builder builder() {
        return new AutoValue_SelectApksCommand.Builder();
    }

    public static SelectApksCommand fromFlags(ParsedFlags flags) {
        Path apksArchivePath = APKS_ARCHIVE_FILE_FLAG.getRequiredValue(flags);
        Path deviceSpecPath = DEVICE_SPEC_FLAG.getRequiredValue(flags);
        Path outputDirectory = OUTPUT_DIRECTORY.getRequiredValue(flags);
        flags.checkNoUnknownFlags();
        Builder commandBuilder = SelectApksCommand.builder();
        FilePreconditions.checkFileExistsAndReadable(apksArchivePath);
        commandBuilder.setApksArchivePath(apksArchivePath);
        FilePreconditions.checkFileExistsAndReadable(deviceSpecPath);
        commandBuilder.setDeviceSpec(SelectApksCommand.parseDeviceSpec(deviceSpecPath.toFile()));
        FilePreconditions.checkDirectoryExists(outputDirectory);
        commandBuilder.setOutputDirectory(outputDirectory);
        return commandBuilder.build();
    }

    private static Devices.DeviceSpec parseDeviceSpec(File deviceSpecFile) {
        Devices.DeviceSpec.Builder builder;
        block28: {
            builder = Devices.DeviceSpec.newBuilder();
            try {
                if (deviceSpecFile.getName().endsWith(PB_JSON)) {
                    try (BufferedReader deviceSpecReader = Files.newBufferedReader(deviceSpecFile.toPath(), StandardCharsets.UTF_8);){
                        JsonFormat.parser().merge((Reader)deviceSpecReader, (Message.Builder)builder);
                        break block28;
                    }
                }
                if (deviceSpecFile.getName().endsWith(PB)) {
                    try (BufferedInputStream deviceSpecStream = new BufferedInputStream(new FileInputStream(deviceSpecFile));){
                        builder.mergeFrom(deviceSpecStream);
                        break block28;
                    }
                }
                throw CommandExecutionException.builder().withMessage("Expected .pb or .pb.json extension of the device spec file but found '%s'.", deviceSpecFile).build();
            }
            catch (IOException e) {
                throw CommandExecutionException.builder().withCause(e).withMessage("I/O error while reading the device spec file '%s'.", deviceSpecFile).build();
            }
        }
        return builder.build();
    }

    public ImmutableList<Path> execute() {
        ImmutableMap<Path, Devices.ApkMatchingMetadata> apksToProcess = ApkMatchingMetadataUtils.toApkMatchingMap(this.readTableOfContents());
        ImmutableList.Builder matchedApksBuilder = ImmutableList.builder();
        ApkMatcher apkMatcher = new ApkMatcher(this.getDeviceSpec());
        for (Map.Entry apk : apksToProcess.entrySet()) {
            Path apkPath = (Path)apk.getKey();
            Devices.ApkMatchingMetadata apkMatchingMetadata = (Devices.ApkMatchingMetadata)apk.getValue();
            if (!apkMatcher.matchesApk(apkMatchingMetadata)) continue;
            matchedApksBuilder.add((Object)apkPath);
        }
        return this.extractMatchedApks((ImmutableList<Path>)matchedApksBuilder.build());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ImmutableList<Path> extractMatchedApks(ImmutableList<Path> matchedApks) {
        ImmutableList.Builder builder = ImmutableList.builder();
        try (ZipFile apksArchive = new ZipFile(this.getApksArchivePath().toFile());){
            for (Path matchedApk : matchedApks) {
                ZipEntry entry = apksArchive.getEntry(matchedApk.toString());
                Preconditions.checkNotNull((Object)entry);
                Path extractedApkPath = this.getOutputDirectory().resolve(matchedApk);
                try {
                    FileOutputStream outputApk = new FileOutputStream(extractedApkPath.toFile());
                    Throwable throwable = null;
                    try {
                        ByteStreams.copy((InputStream)apksArchive.getInputStream(entry), (OutputStream)outputApk);
                        builder.add((Object)extractedApkPath);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (outputApk == null) continue;
                        if (throwable != null) {
                            try {
                                outputApk.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        outputApk.close();
                    }
                }
                catch (IOException e) {
                    throw CommandExecutionException.builder().withCause(e).withMessage("I/O error while extracting APK '%s' from the APK set.", matchedApk).build();
                    return builder.build();
                }
            }
        }
        catch (IOException e) {
            throw CommandExecutionException.builder().withCause(e).withMessage("I/O error while processing the APK set archive '%s'.", this.getApksArchivePath()).build();
        }
    }

    /*
     * Exception decompiling
     */
    private Commands.BuildApksResult readTableOfContents() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void help() {
        CommandHelp.builder().setCommandName(COMMAND_NAME).setCommandDescription("Selects which of the generated APKs should be installed on a given device. The command outputs a list of APKs that should be installed using adb.").addFlag(CommandHelp.FlagDescription.builder().setFlagName(APKS_ARCHIVE_FILE_FLAG.getName()).setExampleValue("archive.apks").setDescription("Path to the archive file generated by the '%s' command.", "build-apks").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(DEVICE_SPEC_FLAG.getName()).setExampleValue("device-spec.pb[.json]").setDescription("Path to the device spec file generated by the '%s' command.", "get-device-spec").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(OUTPUT_DIRECTORY.getName()).setExampleValue("output-dir").setDescription("Path to where the matched APKs will be extracted from the archive file.").build()).build().print(System.out);
    }

    SelectApksCommand() {
    }

    public static abstract class Builder {
        public abstract Builder setApksArchivePath(Path var1);

        public abstract Builder setDeviceSpec(Devices.DeviceSpec var1);

        public abstract Builder setOutputDirectory(Path var1);

        public abstract SelectApksCommand build();
    }
}

