/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.io;

import com.android.bundle.Commands;
import com.android.tools.build.bundletool.exceptions.CommandExecutionException;
import com.android.tools.build.bundletool.io.SplitApkSerializer;
import com.android.tools.build.bundletool.io.StandaloneApkSerializer;
import com.android.tools.build.bundletool.io.ZipBuilder;
import com.android.tools.build.bundletool.io.ZipPath;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.utils.files.FilePreconditions;
import com.google.protobuf.MessageLite;
import java.io.IOException;
import java.nio.file.Path;

public final class ApkSetBuilder {
    private final SplitApkSerializer splitApkSerializer;
    private final StandaloneApkSerializer standaloneApkSerializer;
    private final ZipBuilder apkSetZipBuilder;
    private final Path tempDirectory;

    public ApkSetBuilder(SplitApkSerializer splitApkSerializer, StandaloneApkSerializer standaloneApkSerializer, Path tempDirectory) {
        this.splitApkSerializer = splitApkSerializer;
        this.standaloneApkSerializer = standaloneApkSerializer;
        this.tempDirectory = tempDirectory;
        this.apkSetZipBuilder = new ZipBuilder();
    }

    public Commands.ApkDescription addSplitApk(ModuleSplit split) {
        Commands.ApkDescription apkDescription = this.splitApkSerializer.writeSplitToDisk(split, this.tempDirectory);
        this.addToApkSetArchive(apkDescription);
        return apkDescription;
    }

    public Commands.ApkDescription addStandaloneApk(ModuleSplit split) {
        Commands.ApkDescription apkDescription = this.standaloneApkSerializer.writeToDisk(split, this.tempDirectory);
        this.addToApkSetArchive(apkDescription);
        return apkDescription;
    }

    public Commands.ApkDescription addStandaloneUniversalApk(ModuleSplit split) {
        Commands.ApkDescription apkDescription = this.standaloneApkSerializer.writeToDiskAsUniversal(split, this.tempDirectory);
        this.addToApkSetArchive(apkDescription);
        return apkDescription;
    }

    private void addToApkSetArchive(Commands.ApkDescription apkDescription) {
        Path apkPath = this.tempDirectory.resolve(apkDescription.getPath());
        FilePreconditions.checkFileExistsAndReadable(apkPath);
        this.apkSetZipBuilder.addFileFromDisk(ZipPath.create(apkDescription.getPath()), apkPath.toFile(), ZipBuilder.EntryOption.UNCOMPRESSED);
    }

    public void addTableOfContentsFile(Commands.BuildApksResult tableOfContentsProto) {
        this.apkSetZipBuilder.addFileWithProtoContent(ZipPath.create("toc.pb"), (MessageLite)tableOfContentsProto, new ZipBuilder.EntryOption[0]);
    }

    public void writeTo(Path destinationPath) {
        try {
            this.apkSetZipBuilder.writeTo(destinationPath);
        }
        catch (IOException e) {
            throw CommandExecutionException.builder().withCause(e).withMessage("Error while writing the APK Set archive to '%s'.", destinationPath).build();
        }
    }
}

