/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.io;

import com.google.common.base.Throwables;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Logger;

public final class TempFiles {
    private static final Logger logger = Logger.getLogger(TempFiles.class.getName());

    public static <T> T withTempDirectoryReturning(ActionWithTemporaryDirectory<T> action) {
        Path tempDir = null;
        try {
            tempDir = Files.createTempDirectory("temp", new FileAttribute[0]);
            T t = action.apply(tempDir);
            return t;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (tempDir != null) {
                TempFiles.deleteRecursivelyIgnoringErrors(tempDir);
            }
        }
    }

    public static void withTempDirectory(VoidActionWithTemporaryDirectory action) {
        ActionWithTemporaryDirectory<Void> wrappedAction = tempDir -> {
            action.apply(tempDir);
            return null;
        };
        TempFiles.withTempDirectoryReturning(wrappedAction);
    }

    private static void deleteRecursivelyIgnoringErrors(Path path) {
        try {
            MoreFiles.deleteRecursively((Path)path, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
        }
        catch (IOException e) {
            logger.warning(String.format("Error deleting path '%s': %s", path, Throwables.getStackTraceAsString((Throwable)e)));
        }
    }

    private TempFiles() {
    }

    public static interface VoidActionWithTemporaryDirectory {
        public void apply(Path var1) throws IOException;
    }

    public static interface ActionWithTemporaryDirectory<T> {
        public T apply(Path var1) throws IOException;
    }
}

