/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.targeting;

import com.android.aapt.Resources;
import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.utils.ResourcesUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.Ordering;
import java.util.Comparator;

public final class BestScreenDensitySelector {
    public Resources.ConfigValue selectBestConfigValue(Iterable<Resources.ConfigValue> values, Targeting.ScreenDensity.DensityAlias desiredDensityAlias) {
        Preconditions.checkArgument((boolean)ResourcesUtils.DENSITY_ALIAS_TO_DPI_MAP.containsKey((Object)desiredDensityAlias));
        return this.selectBestConfigValue(values, (Integer)ResourcesUtils.DENSITY_ALIAS_TO_DPI_MAP.get((Object)desiredDensityAlias));
    }

    public Resources.ConfigValue selectBestConfigValue(Iterable<Resources.ConfigValue> values, int desiredDpi) {
        return (Resources.ConfigValue)Ordering.from(BestScreenDensitySelector.comparatorForConfigValues(desiredDpi)).max(values);
    }

    public int selectBestDensity(Iterable<Integer> densities, int desiredDpi) {
        return (Integer)Ordering.from((Comparator)new ScreenDensityComparator(desiredDpi)).max(densities);
    }

    private static Comparator<Resources.ConfigValue> comparatorForConfigValues(int desiredDpi) {
        return Comparator.comparing(BestScreenDensitySelector::getDpiValue, new ScreenDensityComparator(desiredDpi));
    }

    private static int getDpiValue(Resources.ConfigValue configValue) {
        if (configValue.getConfig().getDensity() == 0) {
            return 160;
        }
        return configValue.getConfig().getDensity();
    }

    private static class ScreenDensityComparator
    implements Comparator<Integer> {
        private final int desiredDpi;

        public ScreenDensityComparator(int desiredDpi) {
            Preconditions.checkArgument((desiredDpi != 65535 ? 1 : 0) != 0);
            this.desiredDpi = desiredDpi == 0 || desiredDpi == 65534 ? 160 : desiredDpi;
        }

        @Override
        public int compare(Integer dpiA, Integer dpiB) {
            Preconditions.checkNotNull((Object)dpiA);
            Preconditions.checkNotNull((Object)dpiB);
            if (dpiA.equals(dpiB)) {
                return 0;
            }
            if (dpiA.equals(65534)) {
                return 1;
            }
            if (dpiB.equals(65534)) {
                return -1;
            }
            if (dpiA > dpiB) {
                return -1 * this.compareOrdered(dpiB, dpiA);
            }
            return this.compareOrdered(dpiA, dpiB);
        }

        private int compareOrdered(int lowerDpi, int higherDpi) {
            if (this.desiredDpi >= higherDpi) {
                return -1;
            }
            if (this.desiredDpi <= lowerDpi) {
                return 1;
            }
            if ((2 * lowerDpi - this.desiredDpi) * higherDpi > this.desiredDpi * this.desiredDpi) {
                return 1;
            }
            return -1;
        }
    }
}

