/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.utils.files;

import com.google.common.base.Preconditions;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;

public final class FilePreconditions {
    public static void checkFileDoesNotExist(Path path) {
        Preconditions.checkArgument((!Files.exists(path, new LinkOption[0]) ? 1 : 0) != 0, (String)"File '%s' already exists.", (Object)path);
    }

    public static void checkFileExistsAndReadable(Path path) {
        Preconditions.checkArgument((boolean)Files.exists(path, new LinkOption[0]), (String)"File '%s' was not found.", (Object)path);
        Preconditions.checkArgument((boolean)Files.isReadable(path), (String)"File '%s' is not readable.", (Object)path);
        Preconditions.checkArgument((!Files.isDirectory(path, new LinkOption[0]) ? 1 : 0) != 0, (String)"File '%s' is a directory.", (Object)path);
    }

    public static void checkFileExistsAndExecutable(Path path) {
        Preconditions.checkArgument((boolean)Files.exists(path, new LinkOption[0]), (String)"File '%s' was not found.", (Object)path);
        Preconditions.checkArgument((boolean)Files.isExecutable(path), (String)"File '%s' is not executable.", (Object)path);
    }

    public static void checkFileHasExtension(String fileDescription, Path path, String extension) {
        String filename = path.getFileName().toString();
        Preconditions.checkArgument((boolean)filename.endsWith(extension), (String)"%s '%s' is expected to have '%s' extension.", (Object)fileDescription, (Object)filename, (Object)extension);
    }

    public static void checkFileNamesAreUnique(String fileDescription, Collection<Path> paths) {
        HashMap usedFileNames = new HashMap();
        paths.forEach(path -> {
            String filename = path.getFileName().toString();
            Preconditions.checkArgument((usedFileNames.putIfAbsent(filename, path) == null ? 1 : 0) != 0, (String)"%s must have unique filenames, found duplicates: '%s' and '%s'", (Object)fileDescription, (Object)path, usedFileNames.get(filename));
        });
    }

    public static void checkDirectoryExists(Path path) {
        Preconditions.checkArgument((boolean)Files.exists(path, new LinkOption[0]), (String)"Directory '%s' was not found.", (Object)path);
        Preconditions.checkArgument((boolean)Files.isDirectory(path, new LinkOption[0]), (Object)"'%s' is not a directory.");
    }

    public static void checkDirectoryExistsAndEmpty(Path path) {
        FilePreconditions.checkDirectoryExists(path);
        Preconditions.checkArgument((path.toFile().list().length == 0 ? 1 : 0) != 0, (String)"Directory '%s' is not empty.", (Object)path);
    }

    private FilePreconditions() {
    }
}

