/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.utils.files;

import com.android.tools.build.bundletool.io.ZipPath;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;

public final class FileUtils {
    public static ImmutableList<Path> getDistinctParentPaths(Collection<Path> paths) {
        return (ImmutableList)paths.stream().map(Path::getParent).distinct().collect(ImmutableList.toImmutableList());
    }

    public static String getFileExtension(Path path) {
        Path name = path.getFileName();
        if (name == null) {
            return "";
        }
        String fileName = name.toString();
        int dotIndex = fileName.lastIndexOf(46);
        return dotIndex == -1 ? "" : fileName.substring(dotIndex + 1);
    }

    public static List<ZipPath> toPathWalkingOrder(Collection<ZipPath> paths) {
        ImmutableSortedSet.Builder walkOrderedSet = ImmutableSortedSet.naturalOrder();
        for (ZipPath path : paths) {
            for (int i = 0; i < path.getNameCount(); ++i) {
                walkOrderedSet.add((Object)path.subpath(0, i + 1));
            }
        }
        return walkOrderedSet.build().asList();
    }

    public static boolean equalContent(InputStream is1, InputStream is2) throws IOException {
        is1 = FileUtils.makeBuffered(is1);
        is2 = FileUtils.makeBuffered(is2);
        int c1 = 0;
        int c2 = 0;
        while (c1 != -1 && c2 != -1 && c1 == c2) {
            c1 = is1.read();
            c2 = is2.read();
        }
        return c1 == c2;
    }

    private static InputStream makeBuffered(InputStream is) {
        return is instanceof BufferedInputStream ? is : new BufferedInputStream(is);
    }

    private FileUtils() {
    }
}

