/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.validation;

import com.android.tools.build.bundletool.exceptions.ValidationException;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.validation.SubValidator;
import java.util.Optional;

public class AndroidManifestValidator
extends SubValidator {
    @Override
    public void validateModule(BundleModule module) {
        AndroidManifestValidator.validateFusingConfig(module);
    }

    private static void validateFusingConfig(BundleModule module) {
        Optional<Boolean> includedInFusingByManifest = module.getAndroidManifest().getIsModuleIncludedInFusing();
        if (module.isBaseModule()) {
            if (includedInFusingByManifest.isPresent() && !includedInFusingByManifest.get().booleanValue()) {
                throw new ValidationException("The base module cannot be excluded from fusing.");
            }
        } else if (!includedInFusingByManifest.isPresent()) {
            throw ValidationException.builder().withMessage("Module '%s' must specify its fusing configuration in AndroidManifest.xml.", module.getName()).build();
        }
    }
}

