/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.analysis.type;

import java.util.function.BinaryOperator;
import java.util.stream.Stream;
import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.graph.AppInfo;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.ArrayTypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.Bottom;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.ClassTypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.NullLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.PrimitiveTypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.Top;

public abstract class TypeLatticeElement {
    private final boolean isNullable;

    TypeLatticeElement(boolean isNullable) {
        this.isNullable = isNullable;
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    public boolean mustBeNull() {
        return false;
    }

    abstract TypeLatticeElement asNullable();

    public TypeLatticeElement asNonNullable() {
        throw new Unreachable("Flipping nullable is not allowed in general.");
    }

    String isNullableString() {
        return this.isNullable() ? "" : "@NonNull ";
    }

    public static TypeLatticeElement join(AppInfo appInfo, TypeLatticeElement l1, TypeLatticeElement l2) {
        boolean isNullable;
        if (l1.isBottom()) {
            return l2;
        }
        if (l2.isBottom()) {
            return l1;
        }
        if (l1.isTop() || l2.isTop()) {
            return Top.getInstance();
        }
        if (l1 instanceof NullLatticeElement) {
            return l2.asNullable();
        }
        if (l2 instanceof NullLatticeElement) {
            return l1.asNullable();
        }
        if (l1 instanceof PrimitiveTypeLatticeElement) {
            return l2 instanceof PrimitiveTypeLatticeElement ? l1 : Top.getInstance();
        }
        if (l2 instanceof PrimitiveTypeLatticeElement) {
            return Top.getInstance();
        }
        boolean bl = isNullable = l1.isNullable() || l2.isNullable();
        if (l1.getClass() != l2.getClass()) {
            return TypeLatticeElement.objectType(appInfo, isNullable);
        }
        if (l1.isArrayTypeLatticeElement()) {
            ArrayTypeLatticeElement a1 = l1.asArrayTypeLatticeElement();
            ArrayTypeLatticeElement a2 = l2.asArrayTypeLatticeElement();
            if (a1.getArrayType() == a2.getArrayType()) {
                return a1.isNullable() ? a1 : a2;
            }
            DexType a1BaseReferenceType = a1.getArrayBaseType(appInfo.dexItemFactory);
            int a1Nesting = a1.getNesting();
            if (a1BaseReferenceType.isPrimitiveType()) {
                --a1Nesting;
                a1BaseReferenceType = appInfo.dexItemFactory.objectType;
            }
            DexType a2BaseReferenceType = a2.getArrayBaseType(appInfo.dexItemFactory);
            int a2Nesting = a2.getNesting();
            if (a2BaseReferenceType.isPrimitiveType()) {
                --a2Nesting;
                a2BaseReferenceType = appInfo.dexItemFactory.objectType;
            }
            assert (a1BaseReferenceType.isClassType() && a2BaseReferenceType.isClassType());
            if (a1Nesting == 0 || a2Nesting == 0) {
                return TypeLatticeElement.objectType(appInfo, isNullable);
            }
            if (a1Nesting != a2Nesting) {
                int min = Math.min(a1Nesting, a2Nesting);
                return TypeLatticeElement.objectArrayType(appInfo, min, isNullable);
            }
            DexType lub = a1BaseReferenceType.computeLeastUpperBound(appInfo, a2BaseReferenceType);
            DexType arrayTypeLub = appInfo.dexItemFactory.createArrayType(a1Nesting, lub);
            return new ArrayTypeLatticeElement(arrayTypeLub, isNullable);
        }
        if (l1.isClassTypeLatticeElement()) {
            ClassTypeLatticeElement c1 = l1.asClassTypeLatticeElement();
            ClassTypeLatticeElement c2 = l2.asClassTypeLatticeElement();
            if (c1.getClassType() == c2.getClassType()) {
                return c1.isNullable() ? c1 : c2;
            }
            DexType lub = c1.getClassType().computeLeastUpperBound(appInfo, c2.getClassType());
            return new ClassTypeLatticeElement(lub, isNullable);
        }
        throw new Unreachable("unless a new type lattice is introduced.");
    }

    static BinaryOperator<TypeLatticeElement> joiner(AppInfo appInfo) {
        return (l1, l2) -> TypeLatticeElement.join(appInfo, l1, l2);
    }

    public static TypeLatticeElement join(AppInfo appInfo, Stream<TypeLatticeElement> types) {
        BinaryOperator<TypeLatticeElement> joiner = TypeLatticeElement.joiner(appInfo);
        return types.reduce(Bottom.getInstance(), joiner, joiner);
    }

    public static boolean strictlyLessThan(AppInfo appInfo, TypeLatticeElement l1, TypeLatticeElement l2) {
        if (l1.equals(l2)) {
            return false;
        }
        TypeLatticeElement lub = TypeLatticeElement.join(appInfo, Stream.of(l1, l2));
        return !l1.equals(lub) && l2.equals(lub);
    }

    public static boolean lessThanOrEqual(AppInfo appInfo, TypeLatticeElement l1, TypeLatticeElement l2) {
        return l1.equals(l2) || TypeLatticeElement.strictlyLessThan(appInfo, l1, l2);
    }

    public boolean isTop() {
        return false;
    }

    boolean isBottom() {
        return false;
    }

    public boolean isArrayTypeLatticeElement() {
        return false;
    }

    public ArrayTypeLatticeElement asArrayTypeLatticeElement() {
        return null;
    }

    public boolean isClassTypeLatticeElement() {
        return false;
    }

    public ClassTypeLatticeElement asClassTypeLatticeElement() {
        return null;
    }

    public boolean isPrimitive() {
        return false;
    }

    static ClassTypeLatticeElement objectType(AppInfo appInfo, boolean isNullable) {
        return new ClassTypeLatticeElement(appInfo.dexItemFactory.objectType, isNullable);
    }

    static ArrayTypeLatticeElement objectArrayType(AppInfo appInfo, int nesting, boolean isNullable) {
        return new ArrayTypeLatticeElement(appInfo.dexItemFactory.createArrayType(nesting, appInfo.dexItemFactory.objectType), isNullable);
    }

    public static TypeLatticeElement fromDexType(DexType type, boolean isNullable) {
        if (type == DexItemFactory.nullValueType) {
            return NullLatticeElement.getInstance();
        }
        if (type.isPrimitiveType()) {
            return PrimitiveTypeLatticeElement.getInstance();
        }
        if (type.isClassType()) {
            return new ClassTypeLatticeElement(type, isNullable);
        }
        assert (type.isArrayType());
        return new ArrayTypeLatticeElement(type, isNullable);
    }

    public static TypeLatticeElement newArray(DexType arrayType, boolean isNullable) {
        return new ArrayTypeLatticeElement(arrayType, isNullable);
    }

    public TypeLatticeElement arrayGet(AppInfo appInfo) {
        return Top.getInstance();
    }

    public TypeLatticeElement checkCast(AppInfo appInfo, DexType castType) {
        TypeLatticeElement castTypeLattice = TypeLatticeElement.fromDexType(castType, this.isNullable());
        if (this.mustBeNull()) {
            return castTypeLattice;
        }
        if (TypeLatticeElement.lessThanOrEqual(appInfo, this, castTypeLattice)) {
            return this;
        }
        return castTypeLattice;
    }

    public abstract String toString();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        TypeLatticeElement otherElement = (TypeLatticeElement)o;
        return otherElement.isNullable() == this.isNullable;
    }

    public int hashCode() {
        return this.isNullable ? 1 : 0;
    }
}

