/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.code;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Predicate;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.code.BasicBlock;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.NextUntilIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.Position;

public interface InstructionListIterator
extends ListIterator<Instruction>,
NextUntilIterator<Instruction> {
    default public Instruction peekPrevious() {
        Instruction previous = null;
        if (this.hasPrevious()) {
            previous = (Instruction)this.previous();
            this.next();
        }
        return previous;
    }

    default public Instruction peekNext() {
        Instruction next = null;
        if (this.hasNext()) {
            next = (Instruction)this.next();
            this.previous();
        }
        return next;
    }

    @Override
    default public Instruction nextUntil(Predicate<Instruction> predicate) {
        while (this.hasNext()) {
            Instruction instruction = (Instruction)this.next();
            if (!predicate.test(instruction)) continue;
            return instruction;
        }
        return null;
    }

    default public void setInsertionPosition(Position position) {
    }

    public void removeOrReplaceByDebugLocalRead();

    public void detach();

    public void replaceCurrentInstruction(Instruction var1);

    public BasicBlock split(IRCode var1, ListIterator<BasicBlock> var2);

    default public BasicBlock split(IRCode code) {
        return this.split(code, null);
    }

    public BasicBlock split(IRCode var1, int var2, ListIterator<BasicBlock> var3);

    default public BasicBlock split(IRCode code, int instructions) {
        return this.split(code, instructions, null);
    }

    public BasicBlock inlineInvoke(IRCode var1, IRCode var2, ListIterator<BasicBlock> var3, List<BasicBlock> var4, DexType var5);

    default public BasicBlock inlineInvoke(IRCode code, IRCode inlinee) {
        ArrayList<BasicBlock> blocksToRemove = new ArrayList<BasicBlock>();
        BasicBlock result = this.inlineInvoke(code, inlinee, null, blocksToRemove, null);
        code.removeBlocks(blocksToRemove);
        return result;
    }
}

