/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.commands;

import com.android.bundle.Devices;
import com.android.tools.build.bundletool.commands.AutoValue_GetDeviceSpecCommand;
import com.android.tools.build.bundletool.commands.CommandHelp;
import com.android.tools.build.bundletool.device.DeviceAnalyzer;
import com.android.tools.build.bundletool.exceptions.CommandExecutionException;
import com.android.tools.build.bundletool.utils.EnvironmentVariableProvider;
import com.android.tools.build.bundletool.utils.SystemEnvironmentVariableProvider;
import com.android.tools.build.bundletool.utils.files.FilePreconditions;
import com.android.tools.build.bundletool.utils.flags.Flag;
import com.android.tools.build.bundletool.utils.flags.ParsedFlags;
import com.google.auto.value.AutoValue;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import shadow.bundletool.com.android.ddmlib.AndroidDebugBridge;

@AutoValue
public abstract class GetDeviceSpecCommand {
    public static final String COMMAND_NAME = "get-device-spec";
    private static final Flag<Path> ADB_PATH_FLAG = Flag.path("adb");
    private static final Flag<String> DEVICE_ID_FLAG = Flag.string("device-id");
    private static final Flag<Path> OUTPUT_FLAG = Flag.path("output");
    private static final String ANDROID_HOME_VARIABLE = "ANDROID_HOME";
    private static final EnvironmentVariableProvider DEFAULT_PROVIDER = new SystemEnvironmentVariableProvider();

    public abstract Path getAdbPath();

    public abstract Optional<String> getDeviceId();

    public abstract Path getOutputPath();

    public static Builder builder() {
        return new AutoValue_GetDeviceSpecCommand.Builder();
    }

    public static GetDeviceSpecCommand fromFlags(ParsedFlags flags) {
        return GetDeviceSpecCommand.fromFlags(flags, DEFAULT_PROVIDER);
    }

    public static GetDeviceSpecCommand fromFlags(ParsedFlags flags, EnvironmentVariableProvider environmentVariableProvider) {
        Builder builder = GetDeviceSpecCommand.builder().setOutputPath(OUTPUT_FLAG.getRequiredValue(flags));
        Optional<String> deviceSerialName = DEVICE_ID_FLAG.getValue(flags);
        if (deviceSerialName.isPresent()) {
            builder.setDeviceId(deviceSerialName.get());
        }
        Path adbPath = ADB_PATH_FLAG.getValue(flags).orElseGet(() -> GetDeviceSpecCommand.getAdbPathFromAndroidHome(environmentVariableProvider).orElseThrow(() -> new CommandExecutionException("Unable to determine the location of ADB. Please set the --adb flag or define ANDROID_HOME environment variable.")));
        builder.setAdbPath(adbPath);
        flags.checkNoUnknownFlags();
        return builder.build();
    }

    private static Optional<Path> getAdbPathFromAndroidHome(EnvironmentVariableProvider provider) {
        Optional<String> androidHomePath = provider.getVariable(ANDROID_HOME_VARIABLE);
        return androidHomePath.map(path -> Paths.get(path, "platform-tools", "adb"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        FilePreconditions.checkFileDoesNotExist(this.getOutputPath());
        Path pathToAdb = this.getAdbPath();
        FilePreconditions.checkFileExistsAndExecutable(pathToAdb);
        try {
            AndroidDebugBridge.init(false);
            AndroidDebugBridge adb = AndroidDebugBridge.createBridge(pathToAdb.toString(), false);
            if (adb == null) {
                throw new CommandExecutionException("Failed to start ADB server.");
            }
            Devices.DeviceSpec deviceSpec = new DeviceAnalyzer(adb).analyzeDevice();
            GetDeviceSpecCommand.writeDeviceSpecToFile(deviceSpec, this.getOutputPath());
        }
        finally {
            AndroidDebugBridge.terminate();
        }
    }

    private static void writeDeviceSpecToFile(Devices.DeviceSpec deviceSpec, Path outputFile) {
        try (FileOutputStream outputStream = new FileOutputStream(outputFile.toFile());){
            deviceSpec.writeTo(outputStream);
        }
        catch (FileNotFoundException e) {
            throw CommandExecutionException.builder().withCause(e).withMessage("Can't create the output file '%s'.", outputFile).build();
        }
        catch (IOException e) {
            throw CommandExecutionException.builder().withCause(e).withMessage("I/O error while writing the output file '%s'.", outputFile).build();
        }
    }

    public static void help() {
        CommandHelp.builder().setCommandName(COMMAND_NAME).setCommandDescription("Writes out a file containing the device specifications (i.e. features and properties) of the connected Android device.").addFlag(CommandHelp.FlagDescription.builder().setFlagName(OUTPUT_FLAG.getName()).setExampleValue("device-spec.pb").setDescription("Path to the output device spec file.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(ADB_PATH_FLAG.getName()).setExampleValue("path/to/adb").setOptional(true).setDescription("Path to the adb utility. If absent, an attempt will be made to locate it if the %s environment variable is set.", ANDROID_HOME_VARIABLE).build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(DEVICE_ID_FLAG.getName()).setExampleValue("device-serial-name").setOptional(true).setDescription("Device serial name. Required when more than one device or emulator is connected.").build()).build().print(System.out);
    }

    public static abstract class Builder {
        public abstract Builder setOutputPath(Path var1);

        public abstract Builder setAdbPath(Path var1);

        public abstract Builder setDeviceId(String var1);

        public abstract GetDeviceSpecCommand build();
    }
}

