/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.manifest;

import com.android.aapt.Resources;
import com.android.tools.build.bundletool.manifest.AndroidManifest;
import com.android.tools.build.bundletool.manifest.ProtoXmlHelper;
import com.google.common.collect.ImmutableList;
import java.util.stream.Collectors;

public class ManifestEditor {
    private static final int OPEN_GL_VERSION_MULTIPLIER = 65536;
    private final Resources.XmlNode.Builder rootNodeBuilder;

    public ManifestEditor(Resources.XmlNode rootNode) {
        this.rootNodeBuilder = rootNode.toBuilder();
    }

    public ManifestEditor setMinSdkVersion(int minSdkVersion) {
        return this.setUsesSdkAttribute("minSdkVersion", minSdkVersion, 16843276);
    }

    public ManifestEditor setMaxSdkVersion(int maxSdkVersion) {
        return this.setUsesSdkAttribute("maxSdkVersion", maxSdkVersion, 16843377);
    }

    public ManifestEditor setSplitIdForFeatureSplit(String splitId) {
        Resources.XmlElement.Builder manifestBuilder = ProtoXmlHelper.getExactlyOneElementBuilder(this.rootNodeBuilder, "manifest");
        if (ManifestEditor.isBaseSplit(splitId)) {
            ProtoXmlHelper.removeAttribute(manifestBuilder, "", "split");
        } else {
            Resources.XmlAttribute.Builder splitAttributeBuilder = ProtoXmlHelper.findOrCreateAttributeBuilder(manifestBuilder, "split");
            splitAttributeBuilder.setValue(splitId);
        }
        ProtoXmlHelper.removeAttribute(manifestBuilder, "", "configForSplit");
        Resources.XmlAttribute.Builder isFeatureSplitAttribute = ProtoXmlHelper.findOrCreateAttributeBuilder(manifestBuilder, "http://schemas.android.com/apk/res/android", "isFeatureSplit");
        ProtoXmlHelper.setAttributeValueAsBoolean(isFeatureSplitAttribute, true);
        return this;
    }

    public ManifestEditor setHasCode(boolean value) {
        Resources.XmlElement.Builder applicationBuilder = ProtoXmlHelper.getFirstOrCreateElementBuilder(this.rootNodeBuilder, "application");
        Resources.XmlAttribute.Builder hasCodeBuilder = ProtoXmlHelper.findOrCreateAttributeBuilder(applicationBuilder, "http://schemas.android.com/apk/res/android", "hasCode");
        hasCodeBuilder.setResourceId(0x101000C);
        ProtoXmlHelper.setAttributeValueAsBoolean(hasCodeBuilder, value);
        return this;
    }

    public ManifestEditor setPackage(String packageName) {
        Resources.XmlElement.Builder manifestBuilder = ProtoXmlHelper.getExactlyOneElementBuilder(this.rootNodeBuilder, "manifest");
        Resources.XmlAttribute.Builder packageAttributeBuilder = ProtoXmlHelper.findOrCreateAttributeBuilder(manifestBuilder, "package");
        packageAttributeBuilder.setValue(packageName);
        return this;
    }

    public ManifestEditor setVersionCode(int versionCode) {
        Resources.XmlElement.Builder manifestBuilder = ProtoXmlHelper.getExactlyOneElementBuilder(this.rootNodeBuilder, "manifest");
        Resources.XmlAttribute.Builder versionCodeAttributeBuilder = ProtoXmlHelper.findOrCreateAttributeBuilder(manifestBuilder, "http://schemas.android.com/apk/res/android", "versionCode");
        ProtoXmlHelper.setAttributeValueAsDecimalInteger(versionCodeAttributeBuilder, versionCode);
        versionCodeAttributeBuilder.setResourceId(16843291);
        return this;
    }

    public ManifestEditor setConfigForSplit(String featureSplitId) {
        Resources.XmlElement.Builder manifestBuilder = ProtoXmlHelper.getExactlyOneElementBuilder(this.rootNodeBuilder, "manifest");
        Resources.XmlAttribute.Builder configForSplitAttributeBuilder = ProtoXmlHelper.findOrCreateAttributeBuilder(manifestBuilder, "configForSplit");
        configForSplitAttributeBuilder.setValue(featureSplitId);
        return this;
    }

    public ManifestEditor setSplitId(String splitId) {
        Resources.XmlElement.Builder manifestBuilder = ProtoXmlHelper.getExactlyOneElementBuilder(this.rootNodeBuilder, "manifest");
        Resources.XmlAttribute.Builder splitAttributeBuilder = ProtoXmlHelper.findOrCreateAttributeBuilder(manifestBuilder, "split");
        splitAttributeBuilder.setValue(splitId);
        return this;
    }

    public ManifestEditor setExtractNativeLibsValue(boolean value) {
        Resources.XmlElement.Builder applicationEl = ProtoXmlHelper.getFirstOrCreateElementBuilder(this.rootNodeBuilder, "application");
        Resources.XmlAttribute.Builder attribute = ProtoXmlHelper.findOrCreateAndroidAttributeBuilder(applicationEl, "extractNativeLibs", 16844010);
        ProtoXmlHelper.setAttributeValueAsBoolean(attribute, value);
        return this;
    }

    public ManifestEditor setFusedModuleNames(ImmutableList<String> moduleNames) {
        String moduleNamesString = moduleNames.stream().sorted().distinct().collect(Collectors.joining(","));
        ProtoXmlHelper.getExactlyOneElementBuilder(this.rootNodeBuilder, "application").addChild(Resources.XmlNode.newBuilder().setElement(Resources.XmlElement.newBuilder().setName("meta-data").addAttribute(Resources.XmlAttribute.newBuilder().setNamespaceUri("http://schemas.android.com/apk/res/android").setName("name").setResourceId(0x1010003).setValue("shadow.bundletool.com.android.dynamic.apk.fused.modules")).addAttribute(Resources.XmlAttribute.newBuilder().setNamespaceUri("http://schemas.android.com/apk/res/android").setResourceId(16842788).setName("value").setValue(moduleNamesString))));
        return this;
    }

    public AndroidManifest save() {
        return AndroidManifest.create(this.rootNodeBuilder.build());
    }

    private ManifestEditor setUsesSdkAttribute(String attributeName, int value, int resourceId) {
        Resources.XmlElement.Builder usesSdk = ProtoXmlHelper.getFirstOrCreateElementBuilder(this.rootNodeBuilder, "uses-sdk");
        Resources.XmlAttribute.Builder attributeBuilder = ProtoXmlHelper.findOrCreateAttributeBuilder(usesSdk, "http://schemas.android.com/apk/res/android", attributeName);
        attributeBuilder.setResourceId(resourceId);
        ProtoXmlHelper.setAttributeValueAsDecimalInteger(attributeBuilder, value);
        return this;
    }

    private static boolean isBaseSplit(String splitId) {
        return splitId.isEmpty();
    }
}

