/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.targeting;

import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.targeting.TargetingDimension;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;

public final class TargetingUtils {
    public static Targeting.AssetsDirectoryTargeting toAlternativeTargeting(Targeting.AssetsDirectoryTargeting targeting) {
        Targeting.AssetsDirectoryTargeting.Builder alternativeTargeting = Targeting.AssetsDirectoryTargeting.newBuilder();
        if (targeting.hasTextureCompressionFormat()) {
            alternativeTargeting.getTextureCompressionFormatBuilder().addAllAlternatives(targeting.getTextureCompressionFormat().getValueList());
        }
        if (targeting.hasGraphicsApi()) {
            alternativeTargeting.getGraphicsApiBuilder().addAllAlternatives(targeting.getGraphicsApi().getValueList());
        }
        if (targeting.hasAbi()) {
            alternativeTargeting.getAbiBuilder().addAllAlternatives(targeting.getAbi().getValueList());
        }
        if (targeting.hasLanguage()) {
            alternativeTargeting.getLanguageBuilder().addAllAlternatives((Iterable<String>)targeting.getLanguage().getValueList());
        }
        return alternativeTargeting.build();
    }

    public static ImmutableList<TargetingDimension> getTargetingDimensions(Targeting.AssetsDirectoryTargeting targeting) {
        ImmutableList.Builder dimensions = new ImmutableList.Builder();
        if (targeting.hasAbi()) {
            dimensions.add((Object)TargetingDimension.ABI);
        }
        if (targeting.hasGraphicsApi()) {
            dimensions.add((Object)TargetingDimension.GRAPHICS_API);
        }
        if (targeting.hasTextureCompressionFormat()) {
            dimensions.add((Object)TargetingDimension.TEXTURE_COMPRESSION_FORMAT);
        }
        return dimensions.build();
    }

    public static ImmutableSet<Targeting.Abi> abiValues(Targeting.ApkTargeting targeting) {
        return ImmutableSet.copyOf(targeting.getAbiTargeting().getValueList());
    }

    public static ImmutableSet<Targeting.Abi> abiAlternatives(Targeting.ApkTargeting targeting) {
        return ImmutableSet.copyOf(targeting.getAbiTargeting().getAlternativesList());
    }

    public static ImmutableSet<Targeting.Abi> abiUniverse(Targeting.ApkTargeting targeting) {
        return ImmutableSet.builder().addAll(TargetingUtils.abiValues(targeting)).addAll(TargetingUtils.abiAlternatives(targeting)).build();
    }

    public static ImmutableSet<Targeting.ScreenDensity> densityValues(Targeting.ApkTargeting targeting) {
        return ImmutableSet.copyOf(targeting.getScreenDensityTargeting().getValueList());
    }

    public static ImmutableSet<Targeting.ScreenDensity> densityAlternatives(Targeting.ApkTargeting targeting) {
        return ImmutableSet.copyOf(targeting.getScreenDensityTargeting().getAlternativesList());
    }

    public static ImmutableSet<Targeting.ScreenDensity> densityUniverse(Targeting.ApkTargeting targeting) {
        return ImmutableSet.builder().addAll(TargetingUtils.densityValues(targeting)).addAll(TargetingUtils.densityAlternatives(targeting)).build();
    }
}

