/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.utils;

import com.android.tools.build.bundletool.exceptions.CommandExecutionException;
import com.android.tools.build.bundletool.version.Version;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.Comparator;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public final class Aapt2Locator {
    private static final String AAPT2_GLOB = "glob:**/build-tools/*/{aapt2,aapt2.exe}";
    private static final Pattern VERSION_PATTERN = Pattern.compile("\\d+\\.\\d+\\.\\d+");
    private final PathMatcher aapt2PathMatcher;

    public Aapt2Locator() {
        this(FileSystems.getDefault());
    }

    Aapt2Locator(FileSystem fileSystem) {
        this.aapt2PathMatcher = fileSystem.getPathMatcher(AAPT2_GLOB);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<Path> locateAapt2(Path sdkDir) {
        Path buildToolsDir = sdkDir.resolve("build-tools");
        if (!Files.isDirectory(buildToolsDir, new LinkOption[0])) {
            return Optional.empty();
        }
        try (Stream<Path> paths = Files.find(buildToolsDir, 2, (path, attributes) -> this.aapt2PathMatcher.matches((Path)path) && VERSION_PATTERN.matcher(path.getParent().getFileName().toString()).matches() && Files.isExecutable(path), new FileVisitOption[0]);){
            Optional<Path> optional = paths.max(Comparator.comparing(path -> Version.of(path.getParent().getFileName().toString())));
            return optional;
        }
        catch (IOException e) {
            throw CommandExecutionException.builder().withCause(e).withMessage("Error while trying to locate aapt2 in SDK dir '%s'.", sdkDir).build();
        }
    }
}

