/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.utils.files;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public final class BufferedIo {
    public static BufferedReader reader(InputStream is) {
        return new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
    }

    public static BufferedReader reader(Path file) throws IOException {
        return Files.newBufferedReader(file, StandardCharsets.UTF_8);
    }

    public static InputStream inputStream(Path file) throws IOException {
        return BufferedIo.makeBuffered(Files.newInputStream(file, new OpenOption[0]));
    }

    public static InputStream inputStream(ZipFile zipFile, ZipEntry zipEntry) throws IOException {
        return BufferedIo.makeBuffered(zipFile.getInputStream(zipEntry));
    }

    public static OutputStream outputStream(Path file) throws IOException {
        return BufferedIo.makeBuffered(Files.newOutputStream(file, new OpenOption[0]));
    }

    static InputStream makeBuffered(InputStream is) {
        return is instanceof BufferedInputStream || is instanceof ByteArrayInputStream ? is : new BufferedInputStream(is);
    }

    static OutputStream makeBuffered(OutputStream os) {
        return os instanceof BufferedOutputStream || os instanceof ByteArrayOutputStream ? os : new BufferedOutputStream(os);
    }

    private BufferedIo() {
    }
}

