/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.validation;

import com.android.tools.build.bundletool.exceptions.manifest.ManifestFusingException;
import com.android.tools.build.bundletool.exceptions.manifest.ManifestSdkTargetingException;
import com.android.tools.build.bundletool.manifest.AndroidManifest;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.validation.SubValidator;
import java.util.Optional;

public class AndroidManifestValidator
extends SubValidator {
    @Override
    public void validateModule(BundleModule module) {
        AndroidManifestValidator.validateFusingConfig(module);
        this.validateMinMaxSdk(module);
    }

    private static void validateFusingConfig(BundleModule module) {
        Optional<Boolean> includedInFusingByManifest = module.getAndroidManifest().getIsModuleIncludedInFusing();
        if (module.isBaseModule()) {
            if (includedInFusingByManifest.isPresent() && !includedInFusingByManifest.get().booleanValue()) {
                throw new ManifestFusingException.BaseModuleExcludedFromFusingException();
            }
        } else if (!includedInFusingByManifest.isPresent()) {
            throw new ManifestFusingException.ModuleFusingConfigurationMissingException(module.getName().getName());
        }
    }

    private void validateMinMaxSdk(BundleModule module) {
        AndroidManifest manifest = module.getAndroidManifest();
        Optional<Integer> maxSdk = manifest.getMaxSdkVersion();
        Optional<Integer> minSdk = manifest.getMinSdkVersion();
        maxSdk.filter(sdk -> sdk < 0).map(sdk -> {
            throw new ManifestSdkTargetingException.MaxSdkInvalidException((int)sdk);
        });
        minSdk.filter(sdk -> sdk < 0).map(sdk -> {
            throw new ManifestSdkTargetingException.MinSdkInvalidException((int)sdk);
        });
        if (maxSdk.isPresent() && minSdk.isPresent() && maxSdk.get() < minSdk.get()) {
            throw new ManifestSdkTargetingException.MinSdkGreaterThanMaxSdkException(minSdk.get(), maxSdk.get());
        }
    }
}

