/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.build.apkzlib.zip;

import javax.annotation.Nonnull;
import shadow.bundletool.com.android.tools.build.apkzlib.zip.CentralDirectoryHeader;
import shadow.bundletool.com.android.tools.build.apkzlib.zip.CompressionMethod;

public class CentralDirectoryHeaderCompressInfo {
    public static final long VERSION_WITH_STORE_FILES_ONLY = 10L;
    public static final long VERSION_WITH_DIRECTORIES_AND_DEFLATE = 20L;
    @Nonnull
    private final CompressionMethod mMethod;
    private final long compressedSize;
    private final long versionExtract;

    public CentralDirectoryHeaderCompressInfo(@Nonnull CompressionMethod method, long compressedSize, long versionToExtract) {
        this.mMethod = method;
        this.compressedSize = compressedSize;
        this.versionExtract = versionToExtract;
    }

    public CentralDirectoryHeaderCompressInfo(@Nonnull CentralDirectoryHeader header, @Nonnull CompressionMethod method, long compressedSize) {
        this.mMethod = method;
        this.compressedSize = compressedSize;
        this.versionExtract = header.getName().endsWith("/") || method == CompressionMethod.DEFLATE ? 20L : 10L;
    }

    public long getCompressedSize() {
        return this.compressedSize;
    }

    @Nonnull
    public CompressionMethod getMethod() {
        return this.mMethod;
    }

    public long getVersionExtract() {
        return this.versionExtract;
    }
}

