/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.build.apkzlib.zip;

import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.io.ByteProcessor;
import com.google.common.io.ByteSink;
import com.google.common.io.ByteSource;
import com.google.common.io.CharSource;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import shadow.bundletool.com.android.tools.build.apkzlib.zip.utils.CloseableByteSource;

public class LazyDelegateByteSource
extends CloseableByteSource {
    @Nonnull
    private final ListenableFuture<CloseableByteSource> delegate;

    public LazyDelegateByteSource(@Nonnull ListenableFuture<CloseableByteSource> delegate) {
        this.delegate = delegate;
    }

    @Nonnull
    public ListenableFuture<CloseableByteSource> getDelegate() {
        return this.delegate;
    }

    @Nonnull
    private CloseableByteSource get() throws IOException {
        try {
            CloseableByteSource r = (CloseableByteSource)this.delegate.get();
            if (r == null) {
                throw new IOException("Delegate byte source computation resulted in null.");
            }
            return r;
        }
        catch (InterruptedException e) {
            throw new IOException("Interrupted while waiting for byte source computation.", e);
        }
        catch (ExecutionException e) {
            throw new IOException("Failed to compute byte source.", e);
        }
    }

    public CharSource asCharSource(Charset charset) {
        try {
            return this.get().asCharSource(charset);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public InputStream openBufferedStream() throws IOException {
        return this.get().openBufferedStream();
    }

    public ByteSource slice(long offset, long length) {
        try {
            return this.get().slice(offset, length);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isEmpty() throws IOException {
        return this.get().isEmpty();
    }

    public long size() throws IOException {
        return this.get().size();
    }

    public long copyTo(@Nonnull OutputStream output) throws IOException {
        return this.get().copyTo(output);
    }

    public long copyTo(@Nonnull ByteSink sink) throws IOException {
        return this.get().copyTo(sink);
    }

    public byte[] read() throws IOException {
        return this.get().read();
    }

    public <T> T read(@Nonnull ByteProcessor<T> processor) throws IOException {
        return (T)this.get().read(processor);
    }

    public HashCode hash(HashFunction hashFunction) throws IOException {
        return this.get().hash(hashFunction);
    }

    public boolean contentEquals(@Nonnull ByteSource other) throws IOException {
        return this.get().contentEquals(other);
    }

    public InputStream openStream() throws IOException {
        return this.get().openStream();
    }

    @Override
    public void innerClose() throws IOException {
        this.get().close();
    }
}

