/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.compatproguard;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.List;
import shadow.bundletool.com.android.tools.r8.CompatProguardCommandBuilder;
import shadow.bundletool.com.android.tools.r8.CompilationException;
import shadow.bundletool.com.android.tools.r8.CompilationFailedException;
import shadow.bundletool.com.android.tools.r8.OutputMode;
import shadow.bundletool.com.android.tools.r8.R8;
import shadow.bundletool.com.android.tools.r8.R8Command;
import shadow.bundletool.com.android.tools.r8.Version;
import shadow.bundletool.com.android.tools.r8.origin.CommandLineOrigin;
import shadow.bundletool.com.android.tools.r8.utils.AbortException;

public class CompatProguard {
    private static void printVersion() {
        Version.printToolVersion("CompatProguard");
    }

    private static void printHelp() {
        CompatProguard.printVersion();
        System.out.println("");
        System.out.println("compatproguard [options] --output <dir> <proguard-config>*");
        System.out.println("");
        System.out.println("Where options are:");
        CompatProguardOptions.print();
    }

    private static void run(String[] args) throws IOException, CompilationException, CompilationFailedException {
        CompatProguardOptions options = CompatProguardOptions.parse(args);
        if (options.printHelpAndExit || options.output == null) {
            System.out.println("");
            CompatProguard.printHelp();
            return;
        }
        CompatProguardCommandBuilder builder = new CompatProguardCommandBuilder(options.forceProguardCompatibility);
        ((R8Command.Builder)builder.setOutput(Paths.get(options.output, new String[0]), OutputMode.DexIndexed)).addProguardConfiguration(options.proguardConfig, CommandLineOrigin.INSTANCE).setMinApiLevel(options.minApi);
        if (options.mainDexList != null) {
            builder.addMainDexListFiles(Paths.get(options.mainDexList, new String[0]));
        }
        R8.run((R8Command)builder.build());
    }

    public static void main(String[] args) throws IOException {
        try {
            CompatProguard.run(args);
        }
        catch (CompilationException e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
        catch (CompilationFailedException | AbortException e) {
            System.err.println("Compilation failed");
            System.exit(1);
        }
    }

    public static class CompatProguardOptions {
        public final String output;
        public final int minApi;
        public final boolean forceProguardCompatibility;
        public final boolean multiDex;
        public final String mainDexList;
        public final List<String> proguardConfig;
        public boolean printHelpAndExit;

        CompatProguardOptions(List<String> proguardConfig, String output, int minApi, boolean multiDex, boolean forceProguardCompatibility, String mainDexList, boolean printHelpAndExit) {
            this.output = output;
            this.minApi = minApi;
            this.forceProguardCompatibility = forceProguardCompatibility;
            this.multiDex = multiDex;
            this.mainDexList = mainDexList;
            this.proguardConfig = proguardConfig;
            this.printHelpAndExit = printHelpAndExit;
        }

        public static CompatProguardOptions parse(String[] args) throws CompilationException {
            String output = null;
            int minApi = 1;
            boolean forceProguardCompatibility = false;
            boolean multiDex = false;
            String mainDexList = null;
            boolean printHelpAndExit = false;
            boolean minimalMainDex = false;
            boolean coreLibrary = false;
            boolean noLocals = false;
            ImmutableList.Builder builder = ImmutableList.builder();
            if (args.length > 0) {
                StringBuilder currentLine = new StringBuilder();
                for (int i = 0; i < args.length; ++i) {
                    String arg = args[i];
                    if (arg.charAt(0) == '-') {
                        if (arg.equals("-h") || arg.equals("--help")) {
                            printHelpAndExit = true;
                            continue;
                        }
                        if (arg.equals("--min-api")) {
                            minApi = Integer.valueOf(args[++i]);
                            continue;
                        }
                        if (arg.equals("--force-proguard-compatibility")) {
                            forceProguardCompatibility = true;
                            continue;
                        }
                        if (arg.equals("--output")) {
                            output = args[++i];
                            continue;
                        }
                        if (arg.equals("--multi-dex")) {
                            multiDex = true;
                            continue;
                        }
                        if (arg.equals("--main-dex-list")) {
                            mainDexList = args[++i];
                            continue;
                        }
                        if (arg.startsWith("--main-dex-list=")) {
                            mainDexList = arg.substring("--main-dex-list=".length());
                            continue;
                        }
                        if (arg.equals("--minimal-main-dex")) {
                            minimalMainDex = true;
                            continue;
                        }
                        if (arg.equals("--core-library")) {
                            coreLibrary = true;
                            continue;
                        }
                        if (arg.equals("--no-locals")) {
                            noLocals = true;
                            continue;
                        }
                        if (arg.equals("-outjars")) {
                            throw new CompilationException("Proguard argument -outjar is not supported. Use R8 compatible --output flag");
                        }
                        if (currentLine.length() > 0) {
                            builder.add((Object)currentLine.toString());
                        }
                        currentLine = new StringBuilder(arg);
                        continue;
                    }
                    if (currentLine.length() > 0) {
                        currentLine.append(' ');
                    }
                    currentLine.append(arg);
                }
                if (currentLine.length() > 0) {
                    builder.add((Object)currentLine.toString());
                }
            }
            return new CompatProguardOptions((List<String>)builder.build(), output, minApi, multiDex, forceProguardCompatibility, mainDexList, printHelpAndExit);
        }

        public static void print() {
            System.out.println("-h/--help            : print this help message");
            System.out.println("--min-api n          : specify the targeted min android api level");
            System.out.println("--main-dex-list list : specify main dex list for multi-dexing");
            System.out.println("--minimal-main-dex   : ignored (provided for compatibility)");
            System.out.println("--multi-dex          : ignored (provided for compatibility)");
            System.out.println("--no-locals          : ignored (provided for compatibility)");
            System.out.println("--core-library       : ignored (provided for compatibility)");
        }
    }
}

