/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.dex;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import it.unimi.dsi.fastutil.ints.Int2ReferenceOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import shadow.bundletool.com.android.tools.r8.code.Base1Format;
import shadow.bundletool.com.android.tools.r8.code.Base2Format;
import shadow.bundletool.com.android.tools.r8.code.ConstString;
import shadow.bundletool.com.android.tools.r8.code.ConstStringJumbo;
import shadow.bundletool.com.android.tools.r8.code.FillArrayDataPayload;
import shadow.bundletool.com.android.tools.r8.code.Format21t;
import shadow.bundletool.com.android.tools.r8.code.Format22t;
import shadow.bundletool.com.android.tools.r8.code.Format31t;
import shadow.bundletool.com.android.tools.r8.code.Goto;
import shadow.bundletool.com.android.tools.r8.code.Goto16;
import shadow.bundletool.com.android.tools.r8.code.Goto32;
import shadow.bundletool.com.android.tools.r8.code.IfEq;
import shadow.bundletool.com.android.tools.r8.code.IfEqz;
import shadow.bundletool.com.android.tools.r8.code.IfGe;
import shadow.bundletool.com.android.tools.r8.code.IfGez;
import shadow.bundletool.com.android.tools.r8.code.IfGt;
import shadow.bundletool.com.android.tools.r8.code.IfGtz;
import shadow.bundletool.com.android.tools.r8.code.IfLe;
import shadow.bundletool.com.android.tools.r8.code.IfLez;
import shadow.bundletool.com.android.tools.r8.code.IfLt;
import shadow.bundletool.com.android.tools.r8.code.IfLtz;
import shadow.bundletool.com.android.tools.r8.code.IfNe;
import shadow.bundletool.com.android.tools.r8.code.IfNez;
import shadow.bundletool.com.android.tools.r8.code.Instruction;
import shadow.bundletool.com.android.tools.r8.code.Nop;
import shadow.bundletool.com.android.tools.r8.code.SwitchPayload;
import shadow.bundletool.com.android.tools.r8.graph.DexCode;
import shadow.bundletool.com.android.tools.r8.graph.DexDebugEvent;
import shadow.bundletool.com.android.tools.r8.graph.DexDebugInfo;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexItem;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexString;

public class JumboStringRewriter {
    private final DexEncodedMethod method;
    private final DexString firstJumboString;
    private final DexItemFactory factory;
    private final Map<Instruction, List<Instruction>> instructionTargets = new IdentityHashMap<Instruction, List<Instruction>>();
    private final Int2ReferenceMap<Instruction> debugEventTargets = new Int2ReferenceOpenHashMap();
    private final Map<Instruction, Instruction> payloadToSwitch = new IdentityHashMap<Instruction, Instruction>();
    private final Map<DexCode.Try, TryTargets> tryTargets = new IdentityHashMap<DexCode.Try, TryTargets>();
    private final Map<DexCode.TryHandler, List<Instruction>> handlerTargets = new IdentityHashMap<DexCode.TryHandler, List<Instruction>>();

    public JumboStringRewriter(DexEncodedMethod method, DexString firstJumboString, DexItemFactory factory) {
        this.method = method;
        this.firstJumboString = firstJumboString;
        this.factory = factory;
    }

    public void rewrite() {
        this.recordTargets();
        List<Instruction> newInstructions = this.expandCode();
        this.rewriteInstructionOffsets(newInstructions);
        DexCode.Try[] newTries = this.rewriteTryOffsets();
        DexCode.TryHandler[] newHandlers = this.rewriteHandlerOffsets();
        DexDebugInfo newDebugInfo = this.rewriteDebugInfoOffsets();
        DexCode code = this.method.getCode().asDexCode();
        this.method.setDexCode(new DexCode(code.registerSize, code.incomingRegisterSize, code.outgoingRegisterSize, newInstructions.toArray(new Instruction[newInstructions.size()]), newTries, newHandlers, newDebugInfo, this.firstJumboString));
    }

    private void rewriteInstructionOffsets(List<Instruction> instructions) {
        for (Instruction instruction : instructions) {
            Instruction jump;
            Base2Format condition;
            if (instruction instanceof Format22t) {
                condition = (Format22t)instruction;
                int offset = this.instructionTargets.get(condition).get(0).getOffset() - instruction.getOffset();
                assert (Short.MIN_VALUE <= offset && offset <= Short.MAX_VALUE);
                condition.CCCC = (short)offset;
                continue;
            }
            if (instruction instanceof Format21t) {
                condition = (Format21t)instruction;
                int offset = this.instructionTargets.get(condition).get(0).getOffset() - instruction.getOffset();
                assert (Short.MIN_VALUE <= offset && offset <= Short.MAX_VALUE);
                ((Format21t)condition).BBBB = (short)offset;
                continue;
            }
            if (instruction instanceof Goto) {
                jump = (Goto)instruction;
                int offset = this.instructionTargets.get(jump).get(0).getOffset() - instruction.getOffset();
                assert (-128 <= offset && offset <= 127);
                jump.AA = (byte)offset;
                continue;
            }
            if (instruction instanceof Goto16) {
                jump = (Goto16)instruction;
                int offset = this.instructionTargets.get(jump).get(0).getOffset() - instruction.getOffset();
                assert (Short.MIN_VALUE <= offset && offset <= Short.MAX_VALUE);
                ((Goto16)jump).AAAA = (short)offset;
                continue;
            }
            if (instruction instanceof Goto32) {
                int offset;
                jump = (Goto32)instruction;
                ((Goto32)jump).AAAAAAAA = offset = this.instructionTargets.get(jump).get(0).getOffset() - instruction.getOffset();
                continue;
            }
            if (instruction instanceof Format31t) {
                Format31t payloadUser = (Format31t)instruction;
                int offset = this.instructionTargets.get(payloadUser).get(0).getOffset() - instruction.getOffset();
                payloadUser.setPayloadOffset(offset);
                continue;
            }
            if (!(instruction instanceof SwitchPayload)) continue;
            SwitchPayload payload = (SwitchPayload)instruction;
            Instruction switchInstruction = this.payloadToSwitch.get(payload);
            List<Instruction> switchTargets = this.instructionTargets.get(payload);
            int[] targets = payload.switchTargetOffsets();
            for (int i = 0; i < switchTargets.size(); ++i) {
                Instruction target = switchTargets.get(i);
                targets[i] = target.getOffset() - switchInstruction.getOffset();
            }
        }
    }

    private DexCode.Try[] rewriteTryOffsets() {
        DexCode code = this.method.getCode().asDexCode();
        DexCode.Try[] result = new DexCode.Try[code.tries.length];
        for (int i = 0; i < code.tries.length; ++i) {
            DexCode.Try theTry = code.tries[i];
            TryTargets targets = this.tryTargets.get(theTry);
            result[i] = new DexCode.Try(targets.getStartOffset(), targets.getStartToEndDelta(), -1);
            result[i].handlerIndex = theTry.handlerIndex;
        }
        return result;
    }

    private DexCode.TryHandler[] rewriteHandlerOffsets() {
        DexCode code = this.method.getCode().asDexCode();
        if (code.handlers == null) {
            return null;
        }
        DexCode.TryHandler[] result = new DexCode.TryHandler[code.handlers.length];
        for (int i = 0; i < code.handlers.length; ++i) {
            DexCode.TryHandler handler = code.handlers[i];
            List<Instruction> targets = this.handlerTargets.get(handler);
            Iterator<Instruction> it = targets.iterator();
            int catchAllAddr = -1;
            if (handler.catchAllAddr != -1) {
                catchAllAddr = it.next().getOffset();
            }
            DexCode.TryHandler.TypeAddrPair[] newPairs = new DexCode.TryHandler.TypeAddrPair[handler.pairs.length];
            for (int j = 0; j < handler.pairs.length; ++j) {
                DexCode.TryHandler.TypeAddrPair pair = handler.pairs[j];
                newPairs[j] = new DexCode.TryHandler.TypeAddrPair(pair.type, it.next().getOffset());
            }
            result[i] = new DexCode.TryHandler(newPairs, catchAllAddr);
        }
        return result;
    }

    private DexDebugInfo rewriteDebugInfoOffsets() {
        DexCode code = this.method.getCode().asDexCode();
        if (this.debugEventTargets.size() != 0) {
            int lastOriginalOffset = 0;
            int lastNewOffset = 0;
            ArrayList<DexDebugEvent> events = new ArrayList<DexDebugEvent>();
            for (DexDebugEvent event : code.getDebugInfo().events) {
                Instruction target;
                if (event instanceof DexDebugEvent.AdvancePC) {
                    DexDebugEvent.AdvancePC advance = (DexDebugEvent.AdvancePC)event;
                    target = (Instruction)this.debugEventTargets.get(lastOriginalOffset += advance.delta);
                    int pcDelta = target.getOffset() - lastNewOffset;
                    this.addAdvancementEvents(0, pcDelta, events);
                    lastNewOffset = target.getOffset();
                    continue;
                }
                if (event instanceof DexDebugEvent.Default) {
                    DexDebugEvent.Default defaultEvent = (DexDebugEvent.Default)event;
                    target = (Instruction)this.debugEventTargets.get(lastOriginalOffset += defaultEvent.getPCDelta());
                    int lineDelta = defaultEvent.getLineDelta();
                    int pcDelta = target.getOffset() - lastNewOffset;
                    this.addAdvancementEvents(lineDelta, pcDelta, events);
                    lastNewOffset = target.getOffset();
                    continue;
                }
                events.add(event);
            }
            return new DexDebugInfo(code.getDebugInfo().startLine, code.getDebugInfo().parameters, events.toArray(new DexDebugEvent[events.size()]));
        }
        return code.getDebugInfo();
    }

    private void addAdvancementEvents(int lineDelta, int pcDelta, List<DexDebugEvent> events) {
        if (lineDelta < -4 || lineDelta - -4 >= 15) {
            events.add(this.factory.createAdvanceLine(lineDelta));
            lineDelta = 0;
            if (pcDelta == 0) {
                return;
            }
        }
        if (pcDelta >= 16) {
            events.add(this.factory.createAdvancePC(pcDelta));
            pcDelta = 0;
            if (lineDelta == 0) {
                return;
            }
        }
        int specialOpcode = 10 + (lineDelta - -4) + 15 * pcDelta;
        assert (specialOpcode >= 10);
        assert (specialOpcode <= 255);
        events.add(this.factory.createDefault(specialOpcode));
    }

    private List<Instruction> expandCode() {
        int offsetDelta;
        LinkedList<Instruction> instructions = new LinkedList<Instruction>();
        Collections.addAll(instructions, this.method.getCode().asDexCode().instructions);
        do {
            ListIterator<Instruction> it = instructions.listIterator();
            offsetDelta = 0;
            while (it.hasNext()) {
                List<Instruction> targets;
                Instruction newJump;
                Instruction jump;
                Base2Format newCondition;
                Base2Format condition;
                Instruction instruction = (Instruction)it.next();
                instruction.setOffset(instruction.getOffset() + offsetDelta);
                if (instruction instanceof ConstString) {
                    ConstString string = (ConstString)instruction;
                    if (string.getString().compareTo(this.firstJumboString) < 0) continue;
                    ConstStringJumbo jumboString = new ConstStringJumbo(string.AA, string.getString());
                    jumboString.setOffset(string.getOffset());
                    ++offsetDelta;
                    it.set(jumboString);
                    this.replaceTarget(instruction, jumboString);
                    continue;
                }
                if (instruction instanceof Format22t) {
                    condition = (Format22t)instruction;
                    int offset = this.instructionTargets.get(condition).get(0).getOffset() - instruction.getOffset();
                    if (Short.MIN_VALUE <= offset && offset <= Short.MAX_VALUE) continue;
                    newCondition = null;
                    switch (((Format22t)condition).getType().inverted()) {
                        case EQ: {
                            newCondition = new IfEq(((Format22t)condition).A, ((Format22t)condition).B, 0);
                            break;
                        }
                        case GE: {
                            newCondition = new IfGe(((Format22t)condition).A, ((Format22t)condition).B, 0);
                            break;
                        }
                        case GT: {
                            newCondition = new IfGt(((Format22t)condition).A, ((Format22t)condition).B, 0);
                            break;
                        }
                        case LE: {
                            newCondition = new IfLe(((Format22t)condition).A, ((Format22t)condition).B, 0);
                            break;
                        }
                        case LT: {
                            newCondition = new IfLt(((Format22t)condition).A, ((Format22t)condition).B, 0);
                            break;
                        }
                        case NE: {
                            newCondition = new IfNe(((Format22t)condition).A, ((Format22t)condition).B, 0);
                        }
                    }
                    offsetDelta = this.rewriteIfToIfAndGoto(offsetDelta, it, condition, newCondition);
                    continue;
                }
                if (instruction instanceof Format21t) {
                    condition = (Format21t)instruction;
                    int offset = this.instructionTargets.get(condition).get(0).getOffset() - instruction.getOffset();
                    if (Short.MIN_VALUE <= offset && offset <= Short.MAX_VALUE) continue;
                    newCondition = null;
                    switch (((Format21t)condition).getType().inverted()) {
                        case EQ: {
                            newCondition = new IfEqz((int)((Format21t)condition).AA, 0);
                            break;
                        }
                        case GE: {
                            newCondition = new IfGez((int)((Format21t)condition).AA, 0);
                            break;
                        }
                        case GT: {
                            newCondition = new IfGtz((int)((Format21t)condition).AA, 0);
                            break;
                        }
                        case LE: {
                            newCondition = new IfLez((int)((Format21t)condition).AA, 0);
                            break;
                        }
                        case LT: {
                            newCondition = new IfLtz((int)((Format21t)condition).AA, 0);
                            break;
                        }
                        case NE: {
                            newCondition = new IfNez((int)((Format21t)condition).AA, 0);
                        }
                    }
                    offsetDelta = this.rewriteIfToIfAndGoto(offsetDelta, it, condition, newCondition);
                    continue;
                }
                if (instruction instanceof Goto) {
                    jump = (Goto)instruction;
                    int offset = this.instructionTargets.get(jump).get(0).getOffset() - instruction.getOffset();
                    if (-128 <= offset && offset <= 127) continue;
                    newJump = Short.MIN_VALUE > offset || offset > Short.MAX_VALUE ? new Goto32(offset) : new Goto16(offset);
                    newJump.setOffset(jump.getOffset());
                    it.set(newJump);
                    offsetDelta += newJump.getSize() - ((Base1Format)jump).getSize();
                    this.replaceTarget(jump, newJump);
                    targets = this.instructionTargets.remove(jump);
                    this.instructionTargets.put(newJump, targets);
                    continue;
                }
                if (instruction instanceof Goto16) {
                    jump = (Goto16)instruction;
                    int offset = this.instructionTargets.get(jump).get(0).getOffset() - instruction.getOffset();
                    if (Short.MIN_VALUE <= offset && offset <= Short.MAX_VALUE) continue;
                    newJump = new Goto32(offset);
                    newJump.setOffset(jump.getOffset());
                    it.set(newJump);
                    offsetDelta += newJump.getSize() - ((Base2Format)jump).getSize();
                    this.replaceTarget(jump, newJump);
                    targets = this.instructionTargets.remove(jump);
                    this.instructionTargets.put(newJump, targets);
                    continue;
                }
                if (instruction instanceof Goto32 || instruction instanceof Format31t || !(instruction instanceof SwitchPayload) && !(instruction instanceof FillArrayDataPayload) || instruction.getOffset() % 2 == 0) continue;
                ++offsetDelta;
                it.previous();
                Nop nop = new Nop();
                nop.setOffset(instruction.getOffset());
                it.add(nop);
                it.next();
                instruction.setOffset(instruction.getOffset() + 1);
            }
        } while (offsetDelta > 0);
        return instructions;
    }

    private int rewriteIfToIfAndGoto(int offsetDelta, ListIterator<Instruction> it, Instruction condition, Instruction newCondition) {
        int jumpOffset = condition.getOffset() + condition.getSize();
        Goto32 jump = new Goto32(0);
        jump.setOffset(jumpOffset);
        newCondition.setOffset(condition.getOffset());
        it.set(newCondition);
        this.replaceTarget(condition, newCondition);
        it.add(jump);
        offsetDelta += jump.getSize();
        this.instructionTargets.put(jump, this.instructionTargets.remove(condition));
        Instruction fallthroughInstruction = it.next();
        this.instructionTargets.put(newCondition, Lists.newArrayList((Object[])new Instruction[]{fallthroughInstruction}));
        it.previous();
        return offsetDelta;
    }

    private void replaceTarget(Instruction target, Instruction newTarget) {
        for (List<Instruction> list : this.instructionTargets.values()) {
            list.replaceAll(i -> i == target ? newTarget : i);
        }
        for (Int2ReferenceMap.Entry entry : this.debugEventTargets.int2ReferenceEntrySet()) {
            if (entry.getValue() != target) continue;
            entry.setValue((Object)newTarget);
        }
        for (Map.Entry entry : this.tryTargets.entrySet()) {
            ((TryTargets)entry.getValue()).replaceTarget(target, newTarget);
        }
        for (List list : this.handlerTargets.values()) {
            list.replaceAll(i -> i == target ? newTarget : i);
        }
    }

    private void recordInstructionTargets(Int2ReferenceMap<Instruction> offsetToInstruction) {
        Instruction[] instructions;
        for (Instruction instruction : instructions = this.method.getCode().asDexCode().instructions) {
            Instruction jump;
            Instruction target;
            Base2Format condition;
            if (instruction instanceof Format22t) {
                condition = (Format22t)instruction;
                target = (Instruction)offsetToInstruction.get(condition.getOffset() + ((Format22t)condition).CCCC);
                assert (target != null);
                this.instructionTargets.put(instruction, Lists.newArrayList((Object[])new Instruction[]{target}));
                continue;
            }
            if (instruction instanceof Format21t) {
                condition = (Format21t)instruction;
                target = (Instruction)offsetToInstruction.get(condition.getOffset() + ((Format21t)condition).BBBB);
                assert (target != null);
                this.instructionTargets.put(instruction, Lists.newArrayList((Object[])new Instruction[]{target}));
                continue;
            }
            if (instruction instanceof Goto) {
                jump = (Goto)instruction;
                target = (Instruction)offsetToInstruction.get(jump.getOffset() + ((Goto)jump).AA);
                assert (target != null);
                this.instructionTargets.put(instruction, Lists.newArrayList((Object[])new Instruction[]{target}));
                continue;
            }
            if (instruction instanceof Goto16) {
                jump = (Goto16)instruction;
                target = (Instruction)offsetToInstruction.get(jump.getOffset() + ((Goto16)jump).AAAA);
                assert (target != null);
                this.instructionTargets.put(instruction, Lists.newArrayList((Object[])new Instruction[]{target}));
                continue;
            }
            if (instruction instanceof Goto32) {
                jump = (Goto32)instruction;
                target = (Instruction)offsetToInstruction.get(jump.getOffset() + ((Goto32)jump).AAAAAAAA);
                assert (target != null);
                this.instructionTargets.put(instruction, Lists.newArrayList((Object[])new Instruction[]{target}));
                continue;
            }
            if (instruction instanceof Format31t) {
                Format31t offsetInstruction = (Format31t)instruction;
                target = (Instruction)offsetToInstruction.get(offsetInstruction.getOffset() + offsetInstruction.getPayloadOffset());
                assert (target != null);
                this.instructionTargets.put(instruction, Lists.newArrayList((Object[])new Instruction[]{target}));
                continue;
            }
            if (!(instruction instanceof SwitchPayload)) continue;
            SwitchPayload payload = (SwitchPayload)instruction;
            int[] targetOffsets = payload.switchTargetOffsets();
            int switchOffset = this.payloadToSwitch.get(instruction).getOffset();
            ArrayList<Instruction> targets = new ArrayList<Instruction>();
            for (int i = 0; i < targetOffsets.length; ++i) {
                Instruction target2 = (Instruction)offsetToInstruction.get(switchOffset + targetOffsets[i]);
                assert (target2 != null);
                targets.add(target2);
            }
            this.instructionTargets.put(instruction, targets);
        }
    }

    private void recordDebugEventTargets(Int2ReferenceMap<Instruction> offsetToInstruction) {
        DexDebugInfo debugInfo = this.method.getCode().asDexCode().getDebugInfo();
        if (debugInfo != null) {
            int address = 0;
            for (DexDebugEvent event : debugInfo.events) {
                Instruction target;
                if (event instanceof DexDebugEvent.AdvancePC) {
                    DexDebugEvent.AdvancePC advance = (DexDebugEvent.AdvancePC)event;
                    target = (Instruction)offsetToInstruction.get(address += advance.delta);
                    assert (target != null);
                    this.debugEventTargets.put(address, (Object)target);
                    continue;
                }
                if (!(event instanceof DexDebugEvent.Default)) continue;
                DexDebugEvent.Default defaultEvent = (DexDebugEvent.Default)event;
                target = (Instruction)offsetToInstruction.get(address += defaultEvent.getPCDelta());
                assert (target != null);
                this.debugEventTargets.put(address, (Object)target);
            }
        }
    }

    private void recordTryAndHandlerTargets(Int2ReferenceMap<Instruction> offsetToInstruction, Instruction lastInstruction) {
        DexCode code = this.method.getCode().asDexCode();
        for (DexCode.Try try_ : code.tries) {
            TryTargets targets;
            Instruction start = (Instruction)offsetToInstruction.get(try_.startAddress);
            int endAddress = try_.startAddress + try_.instructionCount;
            if (endAddress > lastInstruction.getOffset()) {
                targets = new TryTargets(start, lastInstruction, true);
            } else {
                Instruction end = (Instruction)offsetToInstruction.get(endAddress);
                targets = new TryTargets(start, end, false);
            }
            assert (try_.startAddress == targets.getStartOffset());
            assert (try_.instructionCount == targets.getStartToEndDelta());
            this.tryTargets.put(try_, targets);
        }
        if (code.handlers != null) {
            for (DexItem dexItem : code.handlers) {
                ArrayList<Instruction> targets = new ArrayList<Instruction>();
                if (((DexCode.TryHandler)dexItem).catchAllAddr != -1) {
                    Instruction target = (Instruction)offsetToInstruction.get(((DexCode.TryHandler)dexItem).catchAllAddr);
                    assert (target != null);
                    targets.add(target);
                }
                for (DexCode.TryHandler.TypeAddrPair pair : ((DexCode.TryHandler)dexItem).pairs) {
                    Instruction target = (Instruction)offsetToInstruction.get(pair.addr);
                    assert (target != null);
                    targets.add(target);
                }
                this.handlerTargets.put((DexCode.TryHandler)dexItem, targets);
            }
        }
    }

    private void recordTargets() {
        Int2ReferenceOpenHashMap offsetToInstruction = new Int2ReferenceOpenHashMap();
        Instruction[] instructions = this.method.getCode().asDexCode().instructions;
        boolean containsPayloads = false;
        for (Instruction instruction : instructions) {
            offsetToInstruction.put(instruction.getOffset(), (Object)instruction);
            if (!(instruction instanceof Format31t)) continue;
            containsPayloads = true;
        }
        if (containsPayloads) {
            for (Instruction instruction : instructions) {
                if (!(instruction instanceof Format31t)) continue;
                Instruction payload = (Instruction)offsetToInstruction.get(instruction.getOffset() + instruction.getPayloadOffset());
                assert (payload != null);
                this.payloadToSwitch.put(payload, instruction);
            }
        }
        this.recordInstructionTargets((Int2ReferenceMap<Instruction>)offsetToInstruction);
        this.recordDebugEventTargets((Int2ReferenceMap<Instruction>)offsetToInstruction);
        Instruction lastInstruction = instructions[instructions.length - 1];
        this.recordTryAndHandlerTargets((Int2ReferenceMap<Instruction>)offsetToInstruction, lastInstruction);
    }

    private static class TryTargets {
        private Instruction start;
        private Instruction end;
        private final boolean endsAfterLastInstruction;

        TryTargets(Instruction start, Instruction end, boolean endsAfterLastInstruction) {
            assert (start != null);
            assert (end != null);
            this.start = start;
            this.end = end;
            this.endsAfterLastInstruction = endsAfterLastInstruction;
        }

        void replaceTarget(Instruction target, Instruction newTarget) {
            if (this.start == target) {
                this.start = newTarget;
            }
            if (this.end == target) {
                this.end = newTarget;
            }
        }

        int getStartOffset() {
            return this.start.getOffset();
        }

        int getStartToEndDelta() {
            if (this.endsAfterLastInstruction) {
                return this.end.getOffset() + this.end.getSize() - this.start.getOffset();
            }
            return this.end.getOffset() - this.start.getOffset();
        }
    }
}

