/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.graph;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import shadow.bundletool.com.android.tools.r8.dex.ApplicationReader;
import shadow.bundletool.com.android.tools.r8.graph.DexApplication;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexString;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.DirectMappedDexApplication;
import shadow.bundletool.com.android.tools.r8.naming.ClassNameMapper;
import shadow.bundletool.com.android.tools.r8.utils.ClasspathClassCollection;
import shadow.bundletool.com.android.tools.r8.utils.LibraryClassCollection;
import shadow.bundletool.com.android.tools.r8.utils.ProgramClassCollection;
import shadow.bundletool.com.android.tools.r8.utils.Timing;

public class LazyLoadedDexApplication
extends DexApplication {
    private final ClasspathClassCollection classpathClasses;
    private final LibraryClassCollection libraryClasses;

    private LazyLoadedDexApplication(ClassNameMapper proguardMap, ProgramClassCollection programClasses, ClasspathClassCollection classpathClasses, LibraryClassCollection libraryClasses, ImmutableSet<DexType> mainDexList, String deadCode, DexItemFactory dexItemFactory, DexString highestSortingString, Timing timing) {
        super(proguardMap, programClasses, mainDexList, deadCode, dexItemFactory, highestSortingString, timing);
        this.classpathClasses = classpathClasses;
        this.libraryClasses = libraryClasses;
    }

    @Override
    public DexClass definitionFor(DexType type) {
        if (type == null) {
            return null;
        }
        Object clazz = this.programClasses.get(type);
        if (clazz == null && this.classpathClasses != null) {
            clazz = this.classpathClasses.get(type);
        }
        if (clazz == null && this.libraryClasses != null) {
            clazz = this.libraryClasses.get(type);
        }
        return clazz;
    }

    private Map<DexType, DexClass> forceLoadAllClasses() {
        IdentityHashMap<DexType, DexClass> loaded = new IdentityHashMap<DexType, DexClass>();
        this.programClasses.forceLoad(type -> true);
        this.programClasses.getAllClasses().forEach(clazz -> {
            DexClass cfr_ignored_0 = loaded.put(clazz.type, (DexClass)clazz);
        });
        if (this.classpathClasses != null) {
            this.classpathClasses.forceLoad(type -> !loaded.containsKey(type));
            this.classpathClasses.getAllClasses().forEach(clazz -> {
                DexClass cfr_ignored_0 = loaded.putIfAbsent(clazz.type, (DexClass)clazz);
            });
        }
        if (this.libraryClasses != null) {
            this.libraryClasses.forceLoad(type -> !loaded.containsKey(type));
            this.libraryClasses.getAllClasses().forEach(clazz -> {
                DexClass cfr_ignored_0 = loaded.putIfAbsent(clazz.type, (DexClass)clazz);
            });
        }
        return loaded;
    }

    public Map<DexType, DexClass> getFullClassMap() {
        return this.forceLoadAllClasses();
    }

    public Builder builder() {
        return new Builder(this);
    }

    @Override
    public DirectMappedDexApplication toDirect() {
        return new DirectMappedDexApplication.Builder(this).build().asDirect();
    }

    @Override
    public String toString() {
        return "Application (" + this.programClasses + "; " + this.classpathClasses + "; " + this.libraryClasses + ")";
    }

    public static class Builder
    extends DexApplication.Builder<Builder> {
        private ClasspathClassCollection classpathClasses;
        private LibraryClassCollection libraryClasses;
        private final ApplicationReader.ProgramClassConflictResolver resolver;

        Builder(ApplicationReader.ProgramClassConflictResolver resolver, DexItemFactory dexItemFactory, Timing timing) {
            super(dexItemFactory, timing);
            this.resolver = resolver;
            this.classpathClasses = null;
            this.libraryClasses = null;
        }

        private Builder(LazyLoadedDexApplication application) {
            super(application);
            this.resolver = ProgramClassCollection::resolveClassConflictImpl;
            this.classpathClasses = application.classpathClasses;
            this.libraryClasses = application.libraryClasses;
        }

        @Override
        Builder self() {
            return this;
        }

        public Builder setClasspathClassCollection(ClasspathClassCollection classes) {
            this.classpathClasses = classes;
            return this;
        }

        public Builder setLibraryClassCollection(LibraryClassCollection classes) {
            this.libraryClasses = classes;
            return this;
        }

        @Override
        public LazyLoadedDexApplication build() {
            return new LazyLoadedDexApplication(this.proguardMap, ProgramClassCollection.create(this.programClasses, this.resolver), this.classpathClasses, this.libraryClasses, ImmutableSet.copyOf((Collection)this.mainDexList), this.deadCode, this.dexItemFactory, this.highestSortingString, this.timing);
        }
    }
}

