/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.code;

import shadow.bundletool.com.android.tools.r8.code.AndInt;
import shadow.bundletool.com.android.tools.r8.code.AndInt2Addr;
import shadow.bundletool.com.android.tools.r8.code.AndIntLit16;
import shadow.bundletool.com.android.tools.r8.code.AndIntLit8;
import shadow.bundletool.com.android.tools.r8.code.AndLong;
import shadow.bundletool.com.android.tools.r8.code.AndLong2Addr;
import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.LogicalBinop;
import shadow.bundletool.com.android.tools.r8.ir.code.NumericType;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;

public class And
extends LogicalBinop {
    public And(NumericType type, Value dest, Value left, Value right) {
        super(type, dest, left, right);
    }

    @Override
    public boolean isAnd() {
        return true;
    }

    @Override
    public And asAnd() {
        return this;
    }

    @Override
    public boolean isCommutative() {
        return true;
    }

    @Override
    public shadow.bundletool.com.android.tools.r8.code.Instruction CreateInt(int dest, int left, int right) {
        return new AndInt(dest, left, right);
    }

    @Override
    public shadow.bundletool.com.android.tools.r8.code.Instruction CreateLong(int dest, int left, int right) {
        assert (dest != left + 1);
        assert (dest != right + 1);
        return new AndLong(dest, left, right);
    }

    @Override
    public shadow.bundletool.com.android.tools.r8.code.Instruction CreateInt2Addr(int left, int right) {
        return new AndInt2Addr(left, right);
    }

    @Override
    public shadow.bundletool.com.android.tools.r8.code.Instruction CreateLong2Addr(int left, int right) {
        return new AndLong2Addr(left, right);
    }

    @Override
    public shadow.bundletool.com.android.tools.r8.code.Instruction CreateIntLit8(int dest, int left, int constant) {
        return new AndIntLit8(dest, left, constant);
    }

    @Override
    public shadow.bundletool.com.android.tools.r8.code.Instruction CreateIntLit16(int dest, int left, int constant) {
        return new AndIntLit16(dest, left, constant);
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        return other.asAnd().type == this.type;
    }

    @Override
    public int compareNonValueParts(Instruction other) {
        return this.type.ordinal() - other.asAnd().type.ordinal();
    }

    @Override
    int foldIntegers(int left, int right) {
        return left & right;
    }

    @Override
    long foldLongs(long left, long right) {
        return left & right;
    }

    @Override
    int getCfOpcode() {
        switch (this.type) {
            case BYTE: 
            case CHAR: 
            case SHORT: 
            case INT: 
            case FLOAT: {
                return 126;
            }
            case LONG: 
            case DOUBLE: {
                return 127;
            }
        }
        throw new Unreachable("Unexpected numeric type in logical and: " + (Object)((Object)this.type));
    }
}

