/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.code;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import shadow.bundletool.com.android.tools.r8.cf.LoadStoreHelper;
import shadow.bundletool.com.android.tools.r8.cf.TypeVerificationHelper;
import shadow.bundletool.com.android.tools.r8.graph.AppInfo;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.code.BasicBlock;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionListIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.ir.conversion.CfBuilder;
import shadow.bundletool.com.android.tools.r8.ir.conversion.DexBuilder;
import shadow.bundletool.com.android.tools.r8.ir.optimize.Inliner;
import shadow.bundletool.com.android.tools.r8.shaking.Enqueuer;
import shadow.bundletool.com.android.tools.r8.utils.InternalOptions;

public class MoveException
extends Instruction {
    public MoveException(Value dest) {
        super(dest);
        dest.markNeverNull();
    }

    public Value dest() {
        return this.outValue;
    }

    @Override
    public void buildDex(DexBuilder builder) {
        int dest = builder.allocatedRegister(this.dest(), this.getNumber());
        builder.add((Instruction)this, (shadow.bundletool.com.android.tools.r8.code.Instruction)new shadow.bundletool.com.android.tools.r8.code.MoveException(dest));
    }

    @Override
    public int maxInValueRegister() {
        assert (false) : "MoveException has no register arguments.";
        return 0;
    }

    @Override
    public int maxOutValueRegister() {
        return 255;
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        assert (other.isMoveException());
        return true;
    }

    @Override
    public int compareNonValueParts(Instruction other) {
        assert (other.isMoveException());
        return 0;
    }

    @Override
    public boolean isMoveException() {
        return true;
    }

    @Override
    public MoveException asMoveException() {
        return this;
    }

    @Override
    public boolean canBeDeadCode(IRCode code, InternalOptions options) {
        return !options.debug && options.isGeneratingDex();
    }

    @Override
    public Inliner.Constraint inliningConstraint(Enqueuer.AppInfoWithLiveness info, DexType invocationContext) {
        return Inliner.Constraint.NEVER;
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
        helper.storeOutValue(this, it);
    }

    @Override
    public void buildCf(CfBuilder builder) {
    }

    private Set<DexType> collectExceptionTypes(DexItemFactory dexItemFactory) {
        HashSet<DexType> exceptionTypes = new HashSet<DexType>(this.getBlock().getPredecessors().size());
        for (BasicBlock block : this.getBlock().getPredecessors()) {
            int size = block.getCatchHandlers().size();
            List<BasicBlock> targets = block.getCatchHandlers().getAllTargets();
            List<DexType> guards = block.getCatchHandlers().getGuards();
            for (int i = 0; i < size; ++i) {
                if (targets.get(i) != this.getBlock()) continue;
                DexType guard = guards.get(i);
                exceptionTypes.add(guard == DexItemFactory.catchAllType ? dexItemFactory.throwableType : guard);
            }
        }
        return exceptionTypes;
    }

    @Override
    public DexType computeVerificationType(TypeVerificationHelper helper) {
        return helper.join(this.collectExceptionTypes(helper.getFactory()));
    }

    @Override
    public TypeLatticeElement evaluate(AppInfo appInfo, Function<Value, TypeLatticeElement> getLatticeElement) {
        Set<DexType> exceptionTypes = this.collectExceptionTypes(appInfo.dexItemFactory);
        return TypeLatticeElement.join(appInfo, exceptionTypes.stream().map(t -> TypeLatticeElement.fromDexType(t, false)));
    }
}

