/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.desugar;

import com.google.common.collect.Sets;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import shadow.bundletool.com.android.tools.r8.ApiLevelException;
import shadow.bundletool.com.android.tools.r8.errors.CompilationError;
import shadow.bundletool.com.android.tools.r8.errors.Unimplemented;
import shadow.bundletool.com.android.tools.r8.graph.DexApplication;
import shadow.bundletool.com.android.tools.r8.graph.DexCallSite;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexItem;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexMethodHandle;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.DexValue;
import shadow.bundletool.com.android.tools.r8.ir.code.BasicBlock;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionListIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeDirect;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeStatic;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeSuper;
import shadow.bundletool.com.android.tools.r8.ir.conversion.IRConverter;
import shadow.bundletool.com.android.tools.r8.ir.desugar.ClassProcessor;
import shadow.bundletool.com.android.tools.r8.ir.desugar.InterfaceProcessor;
import shadow.bundletool.com.android.tools.r8.origin.Origin;
import shadow.bundletool.com.android.tools.r8.utils.InternalOptions;
import shadow.bundletool.com.android.tools.r8.utils.StringDiagnostic;

public final class InterfaceMethodRewriter {
    public static final String COMPANION_CLASS_NAME_SUFFIX = "-CC";
    private static final String DEFAULT_METHOD_PREFIX = "$default$";
    private static final String PRIVATE_METHOD_PREFIX = "$private$";
    private final IRConverter converter;
    private final InternalOptions options;
    final DexItemFactory factory;
    private final Set<DexEncodedMethod> forwardingMethods = Sets.newIdentityHashSet();
    private final Set<DexItem> reportedMissing = Sets.newIdentityHashSet();

    public InterfaceMethodRewriter(IRConverter converter, InternalOptions options) {
        assert (converter != null);
        this.converter = converter;
        this.options = options;
        this.factory = options.itemFactory;
    }

    public void rewriteMethodReferences(DexEncodedMethod encodedMethod, IRCode code) {
        if (this.forwardingMethods.contains(encodedMethod)) {
            return;
        }
        ListIterator<BasicBlock> blocks = code.listIterator();
        while (blocks.hasNext()) {
            BasicBlock block = blocks.next();
            InstructionListIterator instructions = block.listIterator();
            while (instructions.hasNext()) {
                InvokeDirect invokeDirect;
                DexClass clazz;
                DexMethod method;
                Instruction instruction = (Instruction)instructions.next();
                if (instruction.isInvokeCustom()) {
                    DexCallSite callSite = instruction.asInvokeCustom().getCallSite();
                    this.reportStaticInterfaceMethodHandle(encodedMethod.method, callSite.bootstrapMethod);
                    for (DexValue arg : callSite.bootstrapArgs) {
                        if (!(arg instanceof DexValue.DexValueMethodHandle)) continue;
                        this.reportStaticInterfaceMethodHandle(encodedMethod.method, (DexMethodHandle)((DexValue.DexValueMethodHandle)arg).value);
                    }
                    continue;
                }
                if (instruction.isInvokeStatic()) {
                    InvokeStatic invokeStatic = instruction.asInvokeStatic();
                    method = invokeStatic.getInvokedMethod();
                    clazz = this.findDefinitionFor(method.holder);
                    if (clazz == null) {
                        this.warnMissingType(encodedMethod.method, method.holder);
                        continue;
                    }
                    if (!clazz.isInterface() || clazz.isLibraryClass()) continue;
                    instructions.replaceCurrentInstruction(new InvokeStatic(this.staticAsMethodOfCompanionClass(method), invokeStatic.outValue(), invokeStatic.arguments()));
                    continue;
                }
                if (instruction.isInvokeSuper()) {
                    InvokeSuper invokeSuper = instruction.asInvokeSuper();
                    method = invokeSuper.getInvokedMethod();
                    clazz = this.findDefinitionFor(method.holder);
                    if (clazz == null) {
                        this.warnMissingType(encodedMethod.method, method.holder);
                        continue;
                    }
                    if (!clazz.isInterface() || clazz.isLibraryClass()) continue;
                    instructions.replaceCurrentInstruction(new InvokeStatic(this.defaultAsMethodOfCompanionClass(method), invokeSuper.outValue(), invokeSuper.arguments()));
                    continue;
                }
                if (!instruction.isInvokeDirect() || this.factory.isConstructor(method = (invokeDirect = instruction.asInvokeDirect()).getInvokedMethod())) continue;
                clazz = this.findDefinitionFor(method.holder);
                if (clazz == null) {
                    this.warnMissingType(encodedMethod.method, method.holder);
                    continue;
                }
                if (!clazz.isInterface()) continue;
                if (clazz.isLibraryClass()) {
                    throw new CompilationError("Unexpected call to a private method defined in library class " + clazz.toSourceString(), this.getMethodOrigin(encodedMethod.method));
                }
                instructions.replaceCurrentInstruction(new InvokeStatic(this.privateAsMethodOfCompanionClass(method), invokeDirect.outValue(), invokeDirect.arguments()));
            }
        }
    }

    private void reportStaticInterfaceMethodHandle(DexMethod referencedFrom, DexMethodHandle handle) {
        if (handle.type.isInvokeStatic()) {
            DexClass holderClass = this.findDefinitionFor(handle.asMethod().holder);
            if (holderClass == null) {
                this.warnMissingType(referencedFrom, handle.asMethod().holder);
            } else if (holderClass.isInterface()) {
                throw new Unimplemented("Desugaring of static interface method handle as in `" + referencedFrom.toSourceString() + "` in is not yet supported.");
            }
        }
    }

    final DexClass findDefinitionFor(DexType type) {
        return this.converter.appInfo.definitionFor(type);
    }

    final DexType getCompanionClassType(DexType type) {
        assert (type.isClassType());
        String descriptor = type.descriptor.toString();
        String ccTypeDescriptor = descriptor.substring(0, descriptor.length() - 1) + COMPANION_CLASS_NAME_SUFFIX + ";";
        return this.factory.createType(ccTypeDescriptor);
    }

    private boolean isCompanionClassType(DexType type) {
        return type.descriptor.toString().endsWith("-CC;");
    }

    private DexType getInterfaceClassType(DexType type) {
        assert (this.isCompanionClassType(type));
        String descriptor = type.descriptor.toString();
        String interfaceTypeDescriptor = descriptor.substring(0, descriptor.length() - 1 - COMPANION_CLASS_NAME_SUFFIX.length()) + ";";
        return this.factory.createType(interfaceTypeDescriptor);
    }

    private boolean isInMainDexList(DexType iface) {
        return this.converter.appInfo.isInMainDexList(iface);
    }

    final DexMethod staticAsMethodOfCompanionClass(DexMethod method) {
        return this.factory.createMethod(this.getCompanionClassType(method.holder), method.proto, method.name);
    }

    private DexMethod instanceAsMethodOfCompanionClass(DexMethod method, String prefix) {
        DexType[] params = method.proto.parameters.values;
        DexType[] newParams = new DexType[params.length + 1];
        newParams[0] = method.holder;
        System.arraycopy(params, 0, newParams, 1, params.length);
        return this.factory.createMethod(this.getCompanionClassType(method.holder), this.factory.createProto(method.proto.returnType, newParams), this.factory.createString(prefix + method.name.toString()));
    }

    final DexMethod defaultAsMethodOfCompanionClass(DexMethod method) {
        return this.instanceAsMethodOfCompanionClass(method, DEFAULT_METHOD_PREFIX);
    }

    final DexMethod privateAsMethodOfCompanionClass(DexMethod method) {
        return this.instanceAsMethodOfCompanionClass(method, PRIVATE_METHOD_PREFIX);
    }

    public void desugarInterfaceMethods(DexApplication.Builder<?> builder, Flavor flavour) throws ApiLevelException {
        this.forwardingMethods.addAll(this.processClasses(builder, flavour));
        Map<DexProgramClass, DexProgramClass> companionClasses = this.processInterfaces(builder, flavour);
        for (Map.Entry<DexProgramClass, DexProgramClass> entry : companionClasses.entrySet()) {
            builder.addSynthesizedClass(entry.getValue(), this.isInMainDexList(entry.getKey().type));
        }
        for (DexEncodedMethod method : this.forwardingMethods) {
            this.converter.optimizeSynthesizedMethod(method);
        }
    }

    private static boolean shouldProcess(DexProgramClass clazz, Flavor flavour, boolean mustBeInterface) {
        return (!clazz.originatesFromDexResource() || flavour == Flavor.IncludeAllResources) && clazz.isInterface() == mustBeInterface;
    }

    private Map<DexProgramClass, DexProgramClass> processInterfaces(DexApplication.Builder<?> builder, Flavor flavour) {
        InterfaceProcessor processor = new InterfaceProcessor(this);
        for (DexProgramClass clazz : builder.getProgramClasses()) {
            if (!InterfaceMethodRewriter.shouldProcess(clazz, flavour, true)) continue;
            processor.process(clazz.asProgramClass());
        }
        return processor.companionClasses;
    }

    private Set<DexEncodedMethod> processClasses(DexApplication.Builder<?> builder, Flavor flavour) {
        ClassProcessor processor = new ClassProcessor(this);
        for (DexProgramClass clazz : builder.getProgramClasses()) {
            if (!InterfaceMethodRewriter.shouldProcess(clazz, flavour, false)) continue;
            processor.process(clazz);
        }
        return processor.getForwardMethods();
    }

    final boolean isDefaultMethod(DexEncodedMethod method) {
        assert (!method.accessFlags.isConstructor());
        assert (!method.accessFlags.isStatic());
        if (method.accessFlags.isAbstract()) {
            return false;
        }
        if (method.accessFlags.isNative()) {
            throw new Unimplemented("Native default interface methods are not yet supported.");
        }
        if (!method.accessFlags.isPublic()) {
            throw new Unimplemented("Non public default interface methods are not yet supported.");
        }
        return true;
    }

    public void warnMissingInterface(DexClass classToDesugar, DexClass implementing, DexType missing) {
        if (!this.reportedMissing.add(missing)) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("Interface `").append(missing.toSourceString()).append("` not found. It's needed to make sure desugaring of `").append(classToDesugar.toSourceString()).append("` is correct. Desugaring will assume that this interface has no default method.");
        if (classToDesugar != implementing) {
            builder.append(" This missing interface is declared in the direct hierarchy of `").append(implementing).append("`");
        }
        this.options.reporter.warning(new StringDiagnostic(builder.toString(), classToDesugar.getOrigin()));
    }

    private void warnMissingType(DexMethod referencedFrom, DexType missing) {
        if (!this.reportedMissing.add(missing)) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("Type `").append(missing.toSourceString()).append("` was not found, ").append("it is required for default or static interface methods desugaring of `").append(referencedFrom.toSourceString()).append("`");
        this.options.reporter.warning(new StringDiagnostic(builder.toString(), this.getMethodOrigin(referencedFrom)));
    }

    private Origin getMethodOrigin(DexMethod method) {
        DexClass clazz;
        DexType holder = method.getHolder();
        if (this.isCompanionClassType(holder)) {
            holder = this.getInterfaceClassType(holder);
        }
        return (clazz = this.converter.appInfo.definitionFor(holder)) == null ? Origin.unknown() : clazz.getOrigin();
    }

    public static enum Flavor {
        IncludeAllResources,
        ExcludeDexResources;

    }
}

