/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.device;

import com.android.bundle.Commands;
import com.android.bundle.Devices;
import com.android.bundle.Targeting;
import com.google.common.collect.ImmutableMap;
import java.nio.file.Path;
import java.nio.file.Paths;

public class ApkMatchingMetadataUtils {
    public static ImmutableMap<Path, Devices.ApkMatchingMetadata> toApkMatchingMap(Commands.BuildApksResult result) {
        ImmutableMap.Builder mapBuilder = new ImmutableMap.Builder();
        for (Commands.Variant variant : result.getVariantList()) {
            Targeting.VariantTargeting variantTargeting = variant.getTargeting();
            for (Commands.ApkSet apkSet : variant.getApkSetList()) {
                Commands.ModuleMetadata moduleMetadata = apkSet.getModuleMetadata();
                for (Commands.ApkDescription apkDescription : apkSet.getApkDescriptionList()) {
                    mapBuilder.put((Object)Paths.get(apkDescription.getPath(), new String[0]), (Object)Devices.ApkMatchingMetadata.newBuilder().setVariantTargeting(variantTargeting).setModuleMetadata(moduleMetadata).setApkTargeting(apkDescription.getTargeting()).build());
                }
            }
        }
        return mapBuilder.build();
    }
}

