/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.io;

import com.android.bundle.Commands;
import com.android.bundle.Config;
import com.android.tools.build.bundletool.io.ApkSerializerHelper;
import com.android.tools.build.bundletool.model.Aapt2Command;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.model.SigningConfiguration;
import com.google.common.annotations.VisibleForTesting;
import java.nio.file.Path;
import java.util.Optional;

public class StandaloneApkSerializer {
    private final ApkSerializerHelper apkSerializerHelper;

    public StandaloneApkSerializer(Aapt2Command aapt2Command, Optional<SigningConfiguration> signingConfig, Config.Compression compression) {
        this.apkSerializerHelper = new ApkSerializerHelper(aapt2Command, signingConfig, compression);
    }

    public Commands.ApkDescription writeToDisk(ModuleSplit standaloneSplit, Path outputDirectory) {
        String suffix = (standaloneSplit.getSuffix().isEmpty() ? "" : "-") + standaloneSplit.getSuffix();
        String apkFileName = String.format("standalone%s.apk", suffix);
        return this.writeToDiskInternal(standaloneSplit, apkFileName, outputDirectory);
    }

    public Commands.ApkDescription writeToDiskAsUniversal(ModuleSplit standaloneSplit, Path outputDirectory) {
        return this.writeToDiskInternal(standaloneSplit, "universal.apk", outputDirectory);
    }

    @VisibleForTesting
    Commands.ApkDescription writeToDiskInternal(ModuleSplit standaloneSplit, String apkFileName, Path outputDirectory) {
        this.apkSerializerHelper.writeToZipFile(standaloneSplit, outputDirectory.resolve(apkFileName));
        return Commands.ApkDescription.newBuilder().setPath(apkFileName).setStandaloneApkMetadata(Commands.StandaloneApkMetadata.newBuilder().addAllFusedModuleName((Iterable<String>)standaloneSplit.getAndroidManifest().get().getFusedModuleNames())).setTargeting(standaloneSplit.getTargeting()).build();
    }
}

