/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.optimizations;

import com.android.bundle.Config;
import com.android.tools.build.bundletool.model.OptimizationDimension;
import com.android.tools.build.bundletool.optimizations.ApkOptimizations;
import com.android.tools.build.bundletool.utils.EnumMapper;
import com.android.tools.build.bundletool.version.BundleToolVersion;
import com.android.tools.build.bundletool.version.Version;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public final class OptimizationsMerger {
    private static final ImmutableMap<Config.SplitDimension.Value, OptimizationDimension> SPLIT_DIMENSION_ENUM_MAP = EnumMapper.mapByName(Config.SplitDimension.Value.class, OptimizationDimension.class, ImmutableSet.of((Object)((Object)Config.SplitDimension.Value.UNRECOGNIZED), (Object)((Object)Config.SplitDimension.Value.UNSPECIFIED_VALUE)));

    public ApkOptimizations mergeWithDefaults(Config.BundleConfig bundleConfig) {
        return this.mergeWithDefaults(bundleConfig, (ImmutableSet<OptimizationDimension>)ImmutableSet.of());
    }

    @Deprecated
    public ApkOptimizations mergeWithDefaults(Config.BundleConfig bundleConfig, ImmutableSet<OptimizationDimension> optimizationsOverride) {
        if (!optimizationsOverride.isEmpty()) {
            return ApkOptimizations.builder().setSplitDimensions(optimizationsOverride).build();
        }
        String buildVersionString = bundleConfig.getBundletool().getVersion();
        Version bundleToolBuildVersion = buildVersionString.isEmpty() ? BundleToolVersion.getCurrentVersion() : Version.of(buildVersionString);
        ApkOptimizations defaultOptimizations = ApkOptimizations.getDefaultOptimizationsForVersion(bundleToolBuildVersion);
        Config.Optimizations requestedOptimizations = bundleConfig.getOptimizations();
        return ApkOptimizations.builder().setSplitDimensions(this.mergeSplitDimensions(defaultOptimizations.getSplitDimensions(), requestedOptimizations.getSplitsConfig().getSplitDimensionList())).build();
    }

    private ImmutableSet<OptimizationDimension> mergeSplitDimensions(ImmutableSet<OptimizationDimension> defaultSplitDimensions, List<Config.SplitDimension> requestedSplitDimensions) {
        HashSet<OptimizationDimension> mergedDimensions = new HashSet<OptimizationDimension>((Collection<OptimizationDimension>)defaultSplitDimensions);
        for (Config.SplitDimension requestedSplitDimension : requestedSplitDimensions) {
            OptimizationDimension internalDimension = (OptimizationDimension)((Object)SPLIT_DIMENSION_ENUM_MAP.get((Object)requestedSplitDimension.getValue()));
            if (requestedSplitDimension.getNegate()) {
                mergedDimensions.remove((Object)internalDimension);
                continue;
            }
            mergedDimensions.add(internalDimension);
        }
        return ImmutableSet.copyOf(mergedDimensions);
    }
}

