/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.version;

import com.android.tools.build.bundletool.version.AutoValue_Version;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Ordering;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

@AutoValue
public abstract class Version
implements Comparable<Version> {
    private static final Pattern VERSION_REGEXP = Pattern.compile("^(?<major>\\d+?)\\.(?<minor>\\d+?)\\.(?<revision>\\d+?)(-(?<qualifier>.+))?$");

    abstract String getFullVersion();

    abstract int getMajorVersion();

    abstract int getMinorVersion();

    abstract int getRevisionVersion();

    @Nullable
    abstract String getQualifier();

    public static Version of(String version) {
        Matcher matcher = VERSION_REGEXP.matcher(version);
        Preconditions.checkArgument((boolean)matcher.matches(), (String)"Version must match the format '<major>.<minor>.<revision>[-<qualifier>]', but found '%s'.", (Object)version);
        return Version.builder().setFullVersion(version).setMajorVersion(Integer.parseInt(matcher.group("major"))).setMinorVersion(Integer.parseInt(matcher.group("minor"))).setRevisionVersion(Integer.parseInt(matcher.group("revision"))).setQualifier(matcher.group("qualifier")).build();
    }

    @Override
    public int compareTo(Version otherVersion) {
        return ComparisonChain.start().compare(this.getMajorVersion(), otherVersion.getMajorVersion()).compare(this.getMinorVersion(), otherVersion.getMinorVersion()).compare(this.getRevisionVersion(), otherVersion.getRevisionVersion()).compare((Object)this.getQualifier(), (Object)otherVersion.getQualifier(), (Comparator)Ordering.natural().onResultOf(q -> q.replaceAll("^dev$", "")).nullsLast()).result();
    }

    public boolean isOlderThan(Version version) {
        return this.compareTo(version) < 0;
    }

    public String toString() {
        return this.getFullVersion();
    }

    static Builder builder() {
        return new AutoValue_Version.Builder();
    }

    static abstract class Builder {
        Builder() {
        }

        abstract Builder setFullVersion(String var1);

        abstract Builder setMajorVersion(int var1);

        abstract Builder setMinorVersion(int var1);

        abstract Builder setRevisionVersion(int var1);

        abstract Builder setQualifier(String var1);

        abstract Version build();
    }
}

