/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.dex;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import shadow.bundletool.com.android.tools.r8.ClassFileResourceProvider;
import shadow.bundletool.com.android.tools.r8.ProgramResource;
import shadow.bundletool.com.android.tools.r8.ResourceException;
import shadow.bundletool.com.android.tools.r8.StringResource;
import shadow.bundletool.com.android.tools.r8.dex.DexParser;
import shadow.bundletool.com.android.tools.r8.dex.DexReader;
import shadow.bundletool.com.android.tools.r8.errors.CompilationError;
import shadow.bundletool.com.android.tools.r8.graph.ClassKind;
import shadow.bundletool.com.android.tools.r8.graph.DexApplication;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexClasspathClass;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexLibraryClass;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.graph.JarApplicationReader;
import shadow.bundletool.com.android.tools.r8.graph.JarClassFileReader;
import shadow.bundletool.com.android.tools.r8.graph.LazyLoadedDexApplication;
import shadow.bundletool.com.android.tools.r8.naming.ClassNameMapper;
import shadow.bundletool.com.android.tools.r8.utils.AndroidApiLevel;
import shadow.bundletool.com.android.tools.r8.utils.AndroidApp;
import shadow.bundletool.com.android.tools.r8.utils.ClassProvider;
import shadow.bundletool.com.android.tools.r8.utils.ClasspathClassCollection;
import shadow.bundletool.com.android.tools.r8.utils.DescriptorUtils;
import shadow.bundletool.com.android.tools.r8.utils.DexVersion;
import shadow.bundletool.com.android.tools.r8.utils.InternalOptions;
import shadow.bundletool.com.android.tools.r8.utils.LibraryClassCollection;
import shadow.bundletool.com.android.tools.r8.utils.MainDexList;
import shadow.bundletool.com.android.tools.r8.utils.ProgramClassCollection;
import shadow.bundletool.com.android.tools.r8.utils.StringDiagnostic;
import shadow.bundletool.com.android.tools.r8.utils.ThreadUtils;
import shadow.bundletool.com.android.tools.r8.utils.Timing;

public class ApplicationReader {
    private final InternalOptions options;
    private final DexItemFactory itemFactory;
    private final Timing timing;
    private final AndroidApp inputApp;

    public ApplicationReader(AndroidApp inputApp, InternalOptions options, Timing timing) {
        this.options = options;
        this.itemFactory = options.itemFactory;
        this.timing = timing;
        this.inputApp = inputApp;
    }

    public DexApplication read() throws IOException, ExecutionException {
        return this.read((StringResource)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DexApplication read(StringResource proguardMap) throws IOException, ExecutionException {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try {
            DexApplication dexApplication = this.read(proguardMap, executor);
            return dexApplication;
        }
        finally {
            executor.shutdown();
        }
    }

    public final DexApplication read(ExecutorService executorService) throws IOException, ExecutionException {
        return this.read(null, executorService, ProgramClassCollection::resolveClassConflictImpl);
    }

    public final DexApplication read(StringResource proguardMap, ExecutorService executorService) throws IOException, ExecutionException {
        return this.read(proguardMap, executorService, ProgramClassCollection::resolveClassConflictImpl);
    }

    public final DexApplication read(StringResource proguardMap, ExecutorService executorService, ProgramClassConflictResolver resolver) throws IOException, ExecutionException {
        this.timing.begin("DexApplication.read");
        LazyLoadedDexApplication.Builder builder = DexApplication.builder(this.itemFactory, this.timing, resolver);
        try {
            ArrayList futures = new ArrayList();
            this.readProguardMap(proguardMap, builder, executorService, futures);
            this.readMainDexList(builder, executorService, futures);
            ClassReader classReader = new ClassReader(executorService, futures);
            classReader.readSources();
            ThreadUtils.awaitFutures(futures);
            classReader.initializeLazyClassCollection(builder);
        }
        catch (ResourceException e) {
            throw this.options.reporter.fatalError(new StringDiagnostic(e.getMessage(), e.getOrigin()));
        }
        finally {
            this.timing.end();
        }
        return builder.build();
    }

    private int verifyOrComputeMinApiLevel(int computedMinApiLevel, DexReader dexReader) {
        DexVersion version = DexVersion.getDexVersion(dexReader.getDexVersion());
        if (this.options.minApiLevel == AndroidApiLevel.getDefault().getLevel()) {
            computedMinApiLevel = Math.max(computedMinApiLevel, AndroidApiLevel.getMinAndroidApiLevel(version).getLevel());
        } else if (!version.matchesApiLevel(AndroidApiLevel.getAndroidApiLevel(this.options.minApiLevel))) {
            throw new CompilationError("Dex file with version '" + version.getIntValue() + "' cannot be used with min sdk level '" + this.options.minApiLevel + "'.");
        }
        return computedMinApiLevel;
    }

    private void readProguardMap(StringResource map, DexApplication.Builder<?> builder, ExecutorService executorService, List<Future<?>> futures) {
        if (map == null) {
            return;
        }
        futures.add(executorService.submit(() -> {
            try {
                String content = map.getString();
                builder.setProguardMap(ClassNameMapper.mapperFromString(content));
            }
            catch (IOException | ResourceException e) {
                throw new CompilationError("Failure to read proguard map file", e, map.getOrigin());
            }
        }));
    }

    private void readMainDexList(DexApplication.Builder<?> builder, ExecutorService executorService, List<Future<?>> futures) {
        if (this.inputApp.hasMainDexList()) {
            futures.add(executorService.submit(() -> {
                for (StringResource resource : this.inputApp.getMainDexListResources()) {
                    builder.addToMainDexList(MainDexList.parseList(resource, this.itemFactory));
                }
                builder.addToMainDexList(this.inputApp.getMainDexClasses().stream().map(clazz -> this.itemFactory.createType(DescriptorUtils.javaTypeToDescriptor(clazz))).collect(Collectors.toList()));
            }));
        }
    }

    private final class ClassReader {
        private final ExecutorService executorService;
        private final List<Future<?>> futures;
        private final Queue<DexProgramClass> programClasses = new ConcurrentLinkedQueue<DexProgramClass>();
        private final Queue<DexClasspathClass> classpathClasses = new ConcurrentLinkedQueue<DexClasspathClass>();
        private final Queue<DexLibraryClass> libraryClasses = new ConcurrentLinkedQueue<DexLibraryClass>();
        private final JarApplicationReader application = new JarApplicationReader(ApplicationReader.access$000(ApplicationReader.this));

        ClassReader(ExecutorService executorService, List<Future<?>> futures) {
            this.executorService = executorService;
            this.futures = futures;
        }

        private <T extends DexClass> void readDexSources(List<ProgramResource> dexSources, ClassKind classKind, Queue<T> classes) throws IOException, ResourceException {
            if (dexSources.size() > 0) {
                ArrayList<DexParser> dexParsers = new ArrayList<DexParser>(dexSources.size());
                int computedMinApiLevel = ((ApplicationReader)ApplicationReader.this).options.minApiLevel;
                for (ProgramResource input : dexSources) {
                    DexReader dexReader = new DexReader(input);
                    computedMinApiLevel = ApplicationReader.this.verifyOrComputeMinApiLevel(computedMinApiLevel, dexReader);
                    dexParsers.add(new DexParser(dexReader, classKind, ApplicationReader.this.itemFactory));
                }
                ((ApplicationReader)ApplicationReader.this).options.minApiLevel = computedMinApiLevel;
                for (DexParser dexParser : dexParsers) {
                    dexParser.populateIndexTables();
                }
                if (!((ApplicationReader)ApplicationReader.this).options.skipReadingDexCode) {
                    for (DexParser dexParser : dexParsers) {
                        this.futures.add(this.executorService.submit(() -> dexParser.addClassDefsTo(classKind.bridgeConsumer(classes::add))));
                    }
                }
            }
        }

        private <T extends DexClass> void readClassSources(List<ProgramResource> classSources, ClassKind classKind, Queue<T> classes) {
            JarClassFileReader reader = new JarClassFileReader(this.application, classKind.bridgeConsumer(classes::add));
            for (ProgramResource input : classSources) {
                this.futures.add(this.executorService.submit(() -> {
                    try (InputStream is = input.getByteStream();){
                        reader.read(input.getOrigin(), classKind, is);
                    }
                    return null;
                }));
            }
        }

        void readSources() throws IOException, ResourceException {
            Collection<ProgramResource> resources = ApplicationReader.this.inputApp.computeAllProgramResources();
            ArrayList<ProgramResource> dexResources = new ArrayList<ProgramResource>(resources.size());
            ArrayList<ProgramResource> cfResources = new ArrayList<ProgramResource>(resources.size());
            for (ProgramResource resource : resources) {
                if (resource.getKind() == ProgramResource.Kind.DEX) {
                    dexResources.add(resource);
                    continue;
                }
                assert (resource.getKind() == ProgramResource.Kind.CF);
                cfResources.add(resource);
            }
            this.readDexSources(dexResources, ClassKind.PROGRAM, this.programClasses);
            this.readClassSources(cfResources, ClassKind.PROGRAM, this.programClasses);
        }

        private <T extends DexClass> ClassProvider<T> buildClassProvider(ClassKind classKind, Queue<T> preloadedClasses, List<ClassFileResourceProvider> resourceProviders, JarApplicationReader reader) {
            ArrayList providers = new ArrayList();
            if (!preloadedClasses.isEmpty()) {
                providers.add(ClassProvider.forPreloadedClasses(classKind, preloadedClasses));
            }
            for (ClassFileResourceProvider provider : resourceProviders) {
                providers.add(ClassProvider.forClassFileResources(classKind, provider, reader));
            }
            if (providers.isEmpty()) {
                return null;
            }
            return providers.size() == 1 ? (ClassProvider)providers.get(0) : ClassProvider.combine(classKind, providers);
        }

        void initializeLazyClassCollection(LazyLoadedDexApplication.Builder builder) {
            ClassProvider<DexLibraryClass> libraryClassProvider;
            for (DexProgramClass clazz : this.programClasses) {
                builder.addProgramClass(clazz.asProgramClass());
            }
            ClassProvider<DexClasspathClass> classpathClassProvider = this.buildClassProvider(ClassKind.CLASSPATH, this.classpathClasses, ApplicationReader.this.inputApp.getClasspathResourceProviders(), this.application);
            if (classpathClassProvider != null) {
                builder.setClasspathClassCollection(new ClasspathClassCollection(classpathClassProvider));
            }
            if ((libraryClassProvider = this.buildClassProvider(ClassKind.LIBRARY, this.libraryClasses, ApplicationReader.this.inputApp.getLibraryResourceProviders(), this.application)) != null) {
                builder.setLibraryClassCollection(new LibraryClassCollection(libraryClassProvider));
            }
        }
    }

    public static interface ProgramClassConflictResolver {
        public DexProgramClass resolveClassConflict(DexProgramClass var1, DexProgramClass var2);
    }
}

