/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.code;

import java.util.function.Function;
import shadow.bundletool.com.android.tools.r8.cf.LoadStoreHelper;
import shadow.bundletool.com.android.tools.r8.cf.TypeVerificationHelper;
import shadow.bundletool.com.android.tools.r8.cf.code.CfFieldInstruction;
import shadow.bundletool.com.android.tools.r8.code.Format21c;
import shadow.bundletool.com.android.tools.r8.code.Sget;
import shadow.bundletool.com.android.tools.r8.code.SgetBoolean;
import shadow.bundletool.com.android.tools.r8.code.SgetByte;
import shadow.bundletool.com.android.tools.r8.code.SgetChar;
import shadow.bundletool.com.android.tools.r8.code.SgetObject;
import shadow.bundletool.com.android.tools.r8.code.SgetShort;
import shadow.bundletool.com.android.tools.r8.code.SgetWide;
import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.graph.AppInfo;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedField;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.code.FieldInstruction;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionListIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.MemberType;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.ir.conversion.CfBuilder;
import shadow.bundletool.com.android.tools.r8.ir.conversion.DexBuilder;

public class StaticGet
extends FieldInstruction {
    public StaticGet(MemberType type, Value dest, DexField field) {
        super(type, field, dest, (Value)null);
    }

    public Value dest() {
        return this.outValue;
    }

    @Override
    public void buildDex(DexBuilder builder) {
        Format21c instruction;
        int dest = builder.allocatedRegister(this.dest(), this.getNumber());
        switch (this.type) {
            case INT: 
            case FLOAT: 
            case INT_OR_FLOAT: {
                instruction = new Sget(dest, this.field);
                break;
            }
            case LONG: 
            case DOUBLE: 
            case LONG_OR_DOUBLE: {
                instruction = new SgetWide(dest, this.field);
                break;
            }
            case OBJECT: {
                instruction = new SgetObject(dest, this.field);
                break;
            }
            case BOOLEAN: {
                instruction = new SgetBoolean(dest, this.field);
                break;
            }
            case BYTE: {
                instruction = new SgetByte(dest, this.field);
                break;
            }
            case CHAR: {
                instruction = new SgetChar(dest, this.field);
                break;
            }
            case SHORT: {
                instruction = new SgetShort(dest, this.field);
                break;
            }
            default: {
                throw new Unreachable("Unexpected type " + (Object)((Object)this.type));
            }
        }
        builder.add((Instruction)this, (shadow.bundletool.com.android.tools.r8.code.Instruction)instruction);
    }

    @Override
    public boolean instructionTypeCanThrow() {
        return true;
    }

    @Override
    public int maxInValueRegister() {
        return 255;
    }

    @Override
    public int maxOutValueRegister() {
        return 255;
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        StaticGet o = other.asStaticGet();
        return o.field == this.field && o.type == this.type;
    }

    @Override
    public int compareNonValueParts(Instruction other) {
        StaticGet o = other.asStaticGet();
        int result = this.field.slowCompareTo(o.field);
        if (result != 0) {
            return result;
        }
        return this.type.ordinal() - o.type.ordinal();
    }

    @Override
    DexEncodedField lookupTarget(DexType type, AppInfo appInfo) {
        return appInfo.lookupStaticTarget(type, this.field);
    }

    @Override
    public String toString() {
        return super.toString() + "; field: " + this.field.toSourceString();
    }

    @Override
    public boolean isStaticGet() {
        return true;
    }

    @Override
    public StaticGet asStaticGet() {
        return this;
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
        helper.storeOutValue(this, it);
    }

    @Override
    public void buildCf(CfBuilder builder) {
        builder.add(new CfFieldInstruction(178, this.field));
    }

    @Override
    public DexType computeVerificationType(TypeVerificationHelper helper) {
        return this.field.type;
    }

    @Override
    public TypeLatticeElement evaluate(AppInfo appInfo, Function<Value, TypeLatticeElement> getLatticeElement) {
        return TypeLatticeElement.fromDexType(this.field.type, true);
    }
}

