/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.device;

import com.android.tools.build.bundletool.device.Device;
import com.android.tools.build.bundletool.exceptions.CommandExecutionException;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import java.io.Closeable;
import java.nio.file.Path;
import java.util.concurrent.TimeoutException;

public abstract class AdbServer
implements Closeable {
    private static final int ADB_TIMEOUT_MS = 60000;

    public abstract void init(Path var1);

    public ImmutableList<Device> getDevices() throws TimeoutException {
        this.waitTillConnected(60000L);
        return this.getDevicesInternal();
    }

    protected abstract ImmutableList<Device> getDevicesInternal();

    public abstract boolean isConnected();

    private final void waitTillConnected(long timeoutMs) throws TimeoutException {
        if (this.isConnected()) {
            return;
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            Thread.sleep(50L);
            while (!this.isConnected()) {
                if (stopwatch.elapsed().toMillis() > timeoutMs) {
                    throw new TimeoutException(String.format("Timed out (%d ms) while waiting for ADB.", timeoutMs));
                }
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException e) {
            throw CommandExecutionException.builder().withCause(e).withMessage("Interrupted while waiting for ADB.").build();
        }
    }

    @Override
    public abstract void close();
}

