/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.device;

import com.android.bundle.Commands;
import com.android.bundle.Devices;
import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.device.AbiMatcher;
import com.android.tools.build.bundletool.device.LanguageMatcher;
import com.android.tools.build.bundletool.device.ScreenDensityMatcher;
import com.android.tools.build.bundletool.device.SdkVersionMatcher;
import com.android.tools.build.bundletool.exceptions.CommandExecutionException;
import com.android.tools.build.bundletool.model.ZipPath;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Optional;

public class ApkMatcher {
    private final SdkVersionMatcher sdkVersionMatcher;
    private final AbiMatcher abiMatcher;
    private final ScreenDensityMatcher screenDensityMatcher;
    private final LanguageMatcher languageMatcher;
    private final Optional<ImmutableSet<String>> allowedSplitModules;

    public ApkMatcher(Devices.DeviceSpec deviceSpec) {
        this(deviceSpec, Optional.empty());
    }

    public ApkMatcher(Devices.DeviceSpec deviceSpec, Optional<ImmutableSet<String>> allowedSplitModules) {
        Preconditions.checkArgument((!allowedSplitModules.isPresent() || !allowedSplitModules.get().isEmpty() ? 1 : 0) != 0, (Object)"Set of allowed split modules cannot be empty.");
        this.sdkVersionMatcher = new SdkVersionMatcher(deviceSpec);
        this.abiMatcher = new AbiMatcher(deviceSpec);
        this.screenDensityMatcher = new ScreenDensityMatcher(deviceSpec);
        this.languageMatcher = new LanguageMatcher(deviceSpec);
        this.allowedSplitModules = allowedSplitModules;
    }

    public ImmutableList<ZipPath> getMatchingApks(Commands.BuildApksResult buildApksResult) {
        Optional<Commands.Variant> matchingVariant = this.getMatchingVariant(buildApksResult);
        return matchingVariant.isPresent() ? this.getMatchingApksFromVariant(matchingVariant.get()) : ImmutableList.of();
    }

    private Optional<Commands.Variant> getMatchingVariant(Commands.BuildApksResult buildApksResult) {
        ImmutableList matchingVariants = (ImmutableList)buildApksResult.getVariantList().stream().filter(variant -> this.matchesVariantTargeting(variant.getTargeting())).collect(ImmutableList.toImmutableList());
        return matchingVariants.isEmpty() ? Optional.empty() : Optional.of(Iterables.getOnlyElement((Iterable)matchingVariants));
    }

    private ImmutableList<ZipPath> getMatchingApksFromVariant(Commands.Variant variant) {
        ImmutableList.Builder matchedApksBuilder = ImmutableList.builder();
        for (Commands.ApkSet apkSet : variant.getApkSetList()) {
            String moduleName = apkSet.getModuleMetadata().getName();
            for (Commands.ApkDescription apkDescription : apkSet.getApkDescriptionList()) {
                boolean isSplitApk;
                Targeting.ApkTargeting apkTargeting = apkDescription.getTargeting();
                if (!this.matchesApk(apkTargeting, isSplitApk = apkDescription.hasSplitApkMetadata(), moduleName)) continue;
                matchedApksBuilder.add((Object)ZipPath.create(apkDescription.getPath()));
            }
        }
        return matchedApksBuilder.build();
    }

    public boolean matchesApk(Targeting.ApkTargeting apkTargeting, boolean isSplit, String moduleName) {
        boolean matchesTargeting = this.matchesApkTargeting(apkTargeting);
        if (isSplit) {
            boolean matchesSplitModuleName = !this.allowedSplitModules.isPresent() || this.allowedSplitModules.get().contains((Object)moduleName);
            return matchesTargeting && matchesSplitModuleName;
        }
        if (matchesTargeting && this.allowedSplitModules.isPresent()) {
            throw CommandExecutionException.builder().withMessage("Cannot restrict modules when the device matches a non-split APK.").build();
        }
        return matchesTargeting;
    }

    private boolean matchesVariantTargeting(Targeting.VariantTargeting variantTargeting) {
        return this.sdkVersionMatcher.getVariantTargetingPredicate().and(this.abiMatcher.getVariantTargetingPredicate()).and(this.screenDensityMatcher.getVariantTargetingPredicate()).test(variantTargeting);
    }

    private boolean matchesApkTargeting(Targeting.ApkTargeting apkTargeting) {
        return this.sdkVersionMatcher.getApkTargetingPredicate().and(this.abiMatcher.getApkTargetingPredicate()).and(this.screenDensityMatcher.getApkTargetingPredicate()).and(this.languageMatcher.getApkTargetingPredicate()).test(apkTargeting);
    }
}

