/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.code;

import java.util.function.Function;
import shadow.bundletool.com.android.tools.r8.cf.LoadStoreHelper;
import shadow.bundletool.com.android.tools.r8.cf.code.CfArrayLength;
import shadow.bundletool.com.android.tools.r8.graph.AppInfo;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.PrimitiveTypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionListIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.ir.conversion.CfBuilder;
import shadow.bundletool.com.android.tools.r8.ir.conversion.DexBuilder;
import shadow.bundletool.com.android.tools.r8.ir.optimize.Inliner;
import shadow.bundletool.com.android.tools.r8.ir.regalloc.RegisterAllocator;
import shadow.bundletool.com.android.tools.r8.shaking.Enqueuer;

public class ArrayLength
extends Instruction {
    public ArrayLength(Value dest, Value array) {
        super(dest, array);
    }

    public Value dest() {
        return this.outValue;
    }

    public Value array() {
        return (Value)this.inValues.get(0);
    }

    @Override
    public boolean isArrayLength() {
        return true;
    }

    @Override
    public ArrayLength asArrayLength() {
        return this;
    }

    @Override
    public void buildDex(DexBuilder builder) {
        int dest = builder.allocatedRegister(this.dest(), this.getNumber());
        int array = builder.allocatedRegister(this.array(), this.getNumber());
        builder.add((Instruction)this, (shadow.bundletool.com.android.tools.r8.code.Instruction)new shadow.bundletool.com.android.tools.r8.code.ArrayLength(dest, array));
    }

    @Override
    public int maxInValueRegister() {
        return 15;
    }

    @Override
    public int maxOutValueRegister() {
        return 15;
    }

    @Override
    public boolean instructionTypeCanThrow() {
        return true;
    }

    @Override
    public boolean identicalAfterRegisterAllocation(Instruction other, RegisterAllocator allocator) {
        if (super.identicalAfterRegisterAllocation(other, allocator)) {
            return this.array() == other.asArrayLength().array();
        }
        return false;
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        assert (other.isArrayLength());
        return true;
    }

    @Override
    public int compareNonValueParts(Instruction other) {
        assert (other.isArrayLength());
        return 0;
    }

    @Override
    public Inliner.Constraint inliningConstraint(Enqueuer.AppInfoWithLiveness info, DexType invocationContext) {
        return Inliner.Constraint.ALWAYS;
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
        helper.loadInValues(this, it);
        helper.storeOutValue(this, it);
    }

    @Override
    public void buildCf(CfBuilder builder) {
        builder.add(new CfArrayLength());
    }

    @Override
    public TypeLatticeElement evaluate(AppInfo appInfo, Function<Value, TypeLatticeElement> getLatticeElement) {
        return PrimitiveTypeLatticeElement.getInstance();
    }

    @Override
    public boolean throwsNpeIfValueIsNull(Value value) {
        return this.array() == value;
    }
}

