/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.device;

import com.android.tools.build.bundletool.device.Device;
import com.android.tools.build.bundletool.exceptions.InstallationException;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import shadow.bundletool.com.android.ddmlib.AdbCommandRejectedException;
import shadow.bundletool.com.android.ddmlib.IDevice;
import shadow.bundletool.com.android.ddmlib.IShellOutputReceiver;
import shadow.bundletool.com.android.ddmlib.InstallException;
import shadow.bundletool.com.android.ddmlib.ShellCommandUnresponsiveException;
import shadow.bundletool.com.android.ddmlib.TimeoutException;
import shadow.bundletool.com.android.sdklib.AndroidVersion;

public class DdmlibDevice
implements Device {
    private final IDevice device;

    public DdmlibDevice(IDevice device) {
        this.device = device;
    }

    @Override
    public IDevice.DeviceState getState() {
        return this.device.getState();
    }

    @Override
    public AndroidVersion getVersion() {
        return this.device.getVersion();
    }

    @Override
    public ImmutableList<String> getAbis() {
        return ImmutableList.copyOf(this.device.getAbis());
    }

    @Override
    public int getDensity() {
        return this.device.getDensity();
    }

    @Override
    public String getSerialNumber() {
        return this.device.getSerialNumber();
    }

    @Override
    public Optional<String> getProperty(String propertyName) {
        return Optional.ofNullable(this.device.getProperty(propertyName));
    }

    @Override
    public void executeShellCommand(String command, IShellOutputReceiver receiver, long maxTimeToOutputResponse, TimeUnit maxTimeUnits) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        this.device.executeShellCommand(command, receiver, maxTimeToOutputResponse, maxTimeUnits);
    }

    @Override
    public void installApks(ImmutableList<Path> apks, boolean reinstall, long timeout, TimeUnit timeoutUnit) {
        ImmutableList apkFiles = (ImmutableList)apks.stream().map(Path::toFile).collect(ImmutableList.toImmutableList());
        try {
            this.device.installPackages((List<File>)apkFiles, reinstall, (List<String>)ImmutableList.of(), timeout, timeoutUnit);
        }
        catch (InstallException e) {
            throw InstallationException.builder().withCause(e).withMessage("Installation of the app failed.").build();
        }
    }
}

