/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.code;

import shadow.bundletool.com.android.tools.r8.errors.InternalCompilerError;
import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.graph.DexType;

public enum MemberType {
    OBJECT,
    BOOLEAN,
    BYTE,
    CHAR,
    SHORT,
    INT,
    FLOAT,
    LONG,
    DOUBLE,
    INT_OR_FLOAT,
    LONG_OR_DOUBLE;


    public static MemberType fromTypeDescriptorChar(char descriptor) {
        switch (descriptor) {
            case 'L': 
            case '[': {
                return OBJECT;
            }
            case 'Z': {
                return BOOLEAN;
            }
            case 'B': {
                return BYTE;
            }
            case 'S': {
                return SHORT;
            }
            case 'C': {
                return CHAR;
            }
            case 'I': {
                return INT;
            }
            case 'F': {
                return FLOAT;
            }
            case 'J': {
                return LONG;
            }
            case 'D': {
                return DOUBLE;
            }
            case 'V': {
                throw new InternalCompilerError("No member type for void type.");
            }
        }
        throw new Unreachable("Invalid descriptor char '" + descriptor + "'");
    }

    public static MemberType fromDexType(DexType type) {
        return MemberType.fromTypeDescriptorChar((char)type.descriptor.content[0]);
    }
}

