/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.shaking;

import java.util.Set;
import shadow.bundletool.com.android.tools.r8.errors.CompilationError;
import shadow.bundletool.com.android.tools.r8.graph.DexApplication;
import shadow.bundletool.com.android.tools.r8.graph.DexItem;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.shaking.RootSetBuilder;
import shadow.bundletool.com.android.tools.r8.utils.InternalOptions;
import shadow.bundletool.com.android.tools.r8.utils.StringDiagnostic;

public class DiscardedChecker {
    private final Set<DexItem> checkDiscarded;
    private final DexApplication application;
    private boolean fail = false;
    private final InternalOptions options;

    public DiscardedChecker(RootSetBuilder.RootSet rootSet, DexApplication application, InternalOptions options) {
        this.checkDiscarded = rootSet.checkDiscarded;
        this.application = application;
        this.options = options;
    }

    public void run() {
        for (DexProgramClass clazz : this.application.classes()) {
            this.checkItem(clazz);
            clazz.forEachMethod(this::checkItem);
            clazz.forEachField(this::checkItem);
        }
        if (this.fail) {
            throw new CompilationError("Discard checks failed.");
        }
    }

    private void checkItem(DexItem item) {
        if (this.checkDiscarded.contains(item)) {
            this.options.reporter.info(new StringDiagnostic("Item " + item.toSourceString() + " was not discarded."));
            this.fail = true;
        }
    }
}

