/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.splitters;

import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.exceptions.CommandExecutionException;
import com.android.tools.build.bundletool.mergers.D8DexMerger;
import com.android.tools.build.bundletool.mergers.ModuleSplitsToShardMerger;
import com.android.tools.build.bundletool.mergers.SameTargetingMerger;
import com.android.tools.build.bundletool.model.BundleMetadata;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.model.OptimizationDimension;
import com.android.tools.build.bundletool.splitters.AbiNativeLibrariesSplitter;
import com.android.tools.build.bundletool.splitters.ModuleSplitSplitter;
import com.android.tools.build.bundletool.splitters.ScreenDensityResourcesSplitter;
import com.android.tools.build.bundletool.splitters.SplittingPipeline;
import com.android.tools.build.bundletool.utils.TargetingProtoUtils;
import com.android.tools.build.bundletool.version.Version;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;

public class BundleSharder {
    private final Path globalTempDir;
    private final Version bundleVersion;

    public BundleSharder(Path globalTempDir, Version bundleVersion) {
        this.globalTempDir = globalTempDir;
        this.bundleVersion = bundleVersion;
    }

    public ImmutableList<ModuleSplit> shardBundle(ImmutableList<BundleModule> modules, ImmutableSet<OptimizationDimension> shardingDimensions, BundleMetadata bundleMetadata) {
        Preconditions.checkArgument((!modules.isEmpty() ? 1 : 0) != 0, (Object)"At least one module is required.");
        ImmutableList moduleSplits = (ImmutableList)modules.stream().flatMap(module -> this.generateSplits((BundleModule)module, shardingDimensions).stream()).collect(ImmutableList.toImmutableList());
        ImmutableList<ImmutableList<ModuleSplit>> unfusedShards = this.groupSplitsToShards((ImmutableList<ModuleSplit>)moduleSplits);
        return new ModuleSplitsToShardMerger(new D8DexMerger(), this.globalTempDir).merge(unfusedShards, bundleMetadata);
    }

    private ImmutableList<ModuleSplit> generateSplits(BundleModule module, ImmutableSet<OptimizationDimension> shardingDimensions) {
        ImmutableList.Builder rawSplits = ImmutableList.builder();
        SplittingPipeline nativePipeline = this.createNativeLibrariesSplittingPipeline(shardingDimensions);
        rawSplits.addAll(nativePipeline.split(ModuleSplit.forNativeLibraries(module)));
        SplittingPipeline resourcesPipeline = this.createResourcesSplittingPipeline(shardingDimensions);
        rawSplits.addAll(resourcesPipeline.split(ModuleSplit.forResources(module)));
        rawSplits.add((Object)ModuleSplit.forAssets(module));
        rawSplits.add((Object)ModuleSplit.forCode(module));
        rawSplits.add((Object)ModuleSplit.forRoot(module));
        ImmutableList mergedSplits = new SameTargetingMerger().merge((ImmutableCollection<ModuleSplit>)rawSplits.build());
        mergedSplits = (ImmutableList)mergedSplits.stream().map(ModuleSplit::removeSplitName).collect(ImmutableList.toImmutableList());
        long masterSplitCount = mergedSplits.stream().filter(ModuleSplit::isMasterSplit).count();
        Preconditions.checkState((masterSplitCount == 1L ? 1 : 0) != 0, (String)"Expected one master split, got %s.", (long)masterSplitCount);
        return mergedSplits;
    }

    private SplittingPipeline createNativeLibrariesSplittingPipeline(ImmutableSet<OptimizationDimension> shardingDimensions) {
        ImmutableList.Builder nativeSplitters = ImmutableList.builder();
        if (shardingDimensions.contains((Object)OptimizationDimension.ABI)) {
            nativeSplitters.add((Object)new AbiNativeLibrariesSplitter());
        }
        return SplittingPipeline.create((ImmutableList<ModuleSplitSplitter>)nativeSplitters.build());
    }

    private SplittingPipeline createResourcesSplittingPipeline(ImmutableSet<OptimizationDimension> shardingDimensions) {
        ImmutableList.Builder resourceSplitters = ImmutableList.builder();
        if (shardingDimensions.contains((Object)OptimizationDimension.SCREEN_DENSITY)) {
            resourceSplitters.add((Object)new ScreenDensityResourcesSplitter(this.bundleVersion));
        }
        return SplittingPipeline.create((ImmutableList<ModuleSplitSplitter>)resourceSplitters.build());
    }

    private ImmutableList<ImmutableList<ModuleSplit>> groupSplitsToShards(ImmutableList<ModuleSplit> splits) {
        ImmutableSet<ModuleSplit> abiSplits = BundleSharder.subsetWithTargeting(splits, Targeting.ApkTargeting::hasAbiTargeting);
        ImmutableSet<ModuleSplit> densitySplits = BundleSharder.subsetWithTargeting(splits, Targeting.ApkTargeting::hasScreenDensityTargeting);
        Sets.SetView masterSplits = Sets.difference((Set)ImmutableSet.copyOf(splits), (Set)Sets.union(abiSplits, densitySplits));
        Preconditions.checkState((masterSplits.size() >= 1 ? 1 : 0) != 0, (String)"Expecting at least one master split, got %s.", (int)masterSplits.size());
        Preconditions.checkState((boolean)masterSplits.stream().allMatch(split -> split.getApkTargeting().equals(Targeting.ApkTargeting.getDefaultInstance())), (Object)"Master splits are expected to have default targeting.");
        Preconditions.checkState((boolean)Sets.intersection((Set)Sets.newHashSet(abiSplits), (Set)Sets.newHashSet(densitySplits)).isEmpty(), (Object)"No split is expected to have both ABI and screen density targeting.");
        Preconditions.checkState((boolean)BundleSharder.sameTargetedUniverse(densitySplits, split -> TargetingProtoUtils.densityUniverse(split.getApkTargeting())), (Object)"Density splits are expected to cover the same densities.");
        if (!BundleSharder.sameTargetedUniverse(abiSplits, split -> TargetingProtoUtils.abiUniverse(split.getApkTargeting()))) {
            throw CommandExecutionException.builder().withMessage("Modules for standalone APKs must cover the same ABIs when optimizing for ABI.").build();
        }
        Collection abiSplitsSubsets = BundleSharder.nonEmpty(BundleSharder.partitionByTargeting(abiSplits));
        Collection densitySplitsSubsets = BundleSharder.nonEmpty(BundleSharder.partitionByTargeting(densitySplits));
        ImmutableList.Builder shards = ImmutableList.builder();
        for (Collection abiSplitsSubset : abiSplitsSubsets) {
            for (Collection densitySplitsSubset : densitySplitsSubsets) {
                shards.add((Object)ImmutableList.builder().addAll((Iterable)masterSplits).addAll(abiSplitsSubset).addAll(densitySplitsSubset).build());
            }
        }
        return shards.build();
    }

    private static ImmutableSet<ModuleSplit> subsetWithTargeting(ImmutableList<ModuleSplit> splits, Predicate<Targeting.ApkTargeting> predicate) {
        return (ImmutableSet)splits.stream().filter(split -> predicate.test(split.getApkTargeting())).collect(ImmutableSet.toImmutableSet());
    }

    private static Collection<Collection<ModuleSplit>> partitionByTargeting(Collection<ModuleSplit> splits) {
        return Multimaps.index(splits, ModuleSplit::getApkTargeting).asMap().values();
    }

    private static <T> Collection<Collection<T>> nonEmpty(Collection<Collection<T>> x) {
        return x.isEmpty() ? ImmutableList.of((Object)ImmutableList.of()) : x;
    }

    private static boolean sameTargetedUniverse(Set<ModuleSplit> splits, Function<ModuleSplit, Collection<?>> getUniverseFn) {
        long distinctNonEmptyUniverseCount = splits.stream().map(getUniverseFn::apply).filter((Predicate<Collection>)Predicates.not(Collection::isEmpty)).distinct().count();
        return distinctNonEmptyUniverseCount <= 1L;
    }
}

