/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.targeting;

import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.utils.ResourcesUtils;
import com.google.common.collect.Comparators;
import com.google.common.collect.MoreCollectors;
import com.google.common.collect.Ordering;
import java.util.Comparator;
import java.util.Optional;

public final class TargetingComparators {
    private static final Ordering<Targeting.Abi.AbiAlias> ARCHITECTURE_ORDERING = Ordering.explicit((Object)((Object)Targeting.Abi.AbiAlias.ARMEABI), (Object[])new Targeting.Abi.AbiAlias[]{Targeting.Abi.AbiAlias.ARMEABI_V7A, Targeting.Abi.AbiAlias.ARM64_V8A, Targeting.Abi.AbiAlias.X86, Targeting.Abi.AbiAlias.X86_64, Targeting.Abi.AbiAlias.MIPS, Targeting.Abi.AbiAlias.MIPS64});
    private static final Comparator<Targeting.VariantTargeting> ABI_COMPARATOR = Comparator.comparing(TargetingComparators::getAbi, Comparators.emptiesFirst(ARCHITECTURE_ORDERING));
    private static final Comparator<Targeting.VariantTargeting> SDK_COMPARATOR = Comparator.comparing(TargetingComparators::getMinSdk, Comparators.emptiesFirst(Integer::compare));
    private static final Comparator<Targeting.VariantTargeting> SCREEN_DENSITY_COMPARATOR = Comparator.comparing(TargetingComparators::getScreenDensity, Comparators.emptiesFirst(Integer::compare));
    public static final Comparator<Targeting.VariantTargeting> VARIANT_TARGETING_COMPARATOR = SDK_COMPARATOR.thenComparing(ABI_COMPARATOR).thenComparing(SCREEN_DENSITY_COMPARATOR);

    private static Optional<Integer> getMinSdk(Targeting.VariantTargeting variantTargeting) {
        if (variantTargeting.getSdkVersionTargeting().getValueList().isEmpty()) {
            return Optional.empty();
        }
        return variantTargeting.getSdkVersionTargeting().getValueList().stream().map(sdkVersion -> sdkVersion.getMin().getValue()).max(Comparator.naturalOrder());
    }

    private static Optional<Targeting.Abi.AbiAlias> getAbi(Targeting.VariantTargeting variantTargeting) {
        if (variantTargeting.getAbiTargeting().getValueList().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(((Targeting.Abi)variantTargeting.getAbiTargeting().getValueList().stream().collect(MoreCollectors.onlyElement())).getAlias());
    }

    private static Optional<Integer> getScreenDensity(Targeting.VariantTargeting variantTargeting) {
        if (variantTargeting.getScreenDensityTargeting().getValueList().isEmpty()) {
            return Optional.empty();
        }
        Targeting.ScreenDensity densityTargeting = (Targeting.ScreenDensity)variantTargeting.getScreenDensityTargeting().getValueList().stream().collect(MoreCollectors.onlyElement());
        return Optional.of(densityTargeting.getDensityOneofCase() == Targeting.ScreenDensity.DensityOneofCase.DENSITY_ALIAS ? (Integer)ResourcesUtils.DENSITY_ALIAS_TO_DPI_MAP.get((Object)densityTargeting.getDensityAlias()) : Integer.valueOf(densityTargeting.getDensityDpi()));
    }

    private TargetingComparators() {
    }
}

