/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.utils;

import com.android.tools.build.bundletool.utils.ConcurrencyUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Multimaps;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public final class CollectorUtils {
    public static <T, K extends Comparable<K>> Collector<T, ?, ImmutableListMultimap<K, T>> groupingBySortedKeys(Function<? super T, ? extends K> keyFunction) {
        return CollectorUtils.groupingBySortedKeys(keyFunction, Function.identity());
    }

    public static <T, K extends Comparable<K>, V> Collector<T, ?, ImmutableListMultimap<K, V>> groupingBySortedKeys(Function<? super T, ? extends K> keyFunction, Function<? super T, ? extends V> valueFunction) {
        return Collectors.collectingAndThen(Multimaps.toMultimap(keyFunction, valueFunction, () -> ((MultimapBuilder.ListMultimapBuilder)MultimapBuilder.treeKeys().arrayListValues()).build()), ImmutableListMultimap::copyOf);
    }

    public static <T> Collector<ListenableFuture<T>, List<T>, ImmutableList<T>> waitForAll() {
        return Collector.of(ArrayList::new, (list, future) -> list.add(ConcurrencyUtils.waitFor(future)), (list1, list2) -> {
            list1.addAll(list2);
            return list1;
        }, ImmutableList::copyOf, new Collector.Characteristics[0]);
    }

    private CollectorUtils() {
    }
}

