/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.utils;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;

public final class PathUtils {
    private PathUtils() {
    }

    public static void deleteRecursivelyIfExists(Path path) throws IOException {
        if (Files.isDirectory(path, new LinkOption[0])) {
            try (Stream<Path> pathsInDir = Files.list(path);){
                pathsInDir.forEach(pathInDir -> {
                    try {
                        PathUtils.deleteRecursivelyIfExists(pathInDir);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                });
            }
        }
        Files.deleteIfExists(path);
    }

    public static String toSystemIndependentPath(Path path) {
        String filePath = path.toString();
        if (!path.getFileSystem().getSeparator().equals("/")) {
            return filePath.replace(path.getFileSystem().getSeparator(), "/");
        }
        return filePath;
    }

    public static Path createTmpToRemoveOnShutdown(String prefix) throws IOException {
        Path tmpFile = Files.createTempFile(prefix, "", new FileAttribute[0]);
        PathUtils.addRemovePathHook(tmpFile);
        return tmpFile;
    }

    public static Path createTmpDirToRemoveOnShutdown(String prefix) throws IOException {
        Path tmpDir = Files.createTempDirectory(prefix, new FileAttribute[0]);
        PathUtils.addRemovePathHook(tmpDir);
        return tmpDir;
    }

    public static List<Path> getClassPathItems(String classPath) {
        Iterable components = Splitter.on((String)File.pathSeparator).split((CharSequence)classPath);
        ArrayList classPathJars = Lists.newArrayList();
        PathMatcher zipOrJar = FileSystems.getDefault().getPathMatcher(String.format("glob:**{%s,%s}", "zip", "jar"));
        for (String component : components) {
            Path componentPath = Paths.get(component, new String[0]);
            if (Files.isRegularFile(componentPath, new LinkOption[0])) {
                classPathJars.add(componentPath);
                continue;
            }
            try {
                Files.walk(componentPath, new FileVisitOption[0]).filter(zipOrJar::matches).forEach(classPathJars::add);
            }
            catch (IOException iOException) {}
        }
        return classPathJars;
    }

    public static void addRemovePathHook(Path path) {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                PathUtils.deleteRecursivelyIfExists(path);
            }
            catch (IOException e) {
                Logger.getLogger(PathUtils.class.getName()).log(Level.WARNING, "Unable to delete " + path, e);
            }
        }));
    }
}

