
package com.android.tools.build.bundletool.model;

import com.android.aapt.Resources;
import com.android.bundle.Config;
import com.android.bundle.Files;
import com.google.common.collect.ImmutableMap;
import java.util.Optional;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
 abstract class $AutoValue_BundleModule extends BundleModule {

  private final BundleModuleName name;
  private final Config.BundleConfig bundleConfig;
  private final Resources.XmlNode androidManifestProto;
  private final Optional<Resources.ResourceTable> resourceTable;
  private final Optional<Files.Assets> assetsConfig;
  private final Optional<Files.NativeLibraries> nativeConfig;
  private final ImmutableMap<ZipPath, ModuleEntry> entryMap;

  $AutoValue_BundleModule(
      BundleModuleName name,
      Config.BundleConfig bundleConfig,
      Resources.XmlNode androidManifestProto,
      Optional<Resources.ResourceTable> resourceTable,
      Optional<Files.Assets> assetsConfig,
      Optional<Files.NativeLibraries> nativeConfig,
      ImmutableMap<ZipPath, ModuleEntry> entryMap) {
    if (name == null) {
      throw new NullPointerException("Null name");
    }
    this.name = name;
    if (bundleConfig == null) {
      throw new NullPointerException("Null bundleConfig");
    }
    this.bundleConfig = bundleConfig;
    if (androidManifestProto == null) {
      throw new NullPointerException("Null androidManifestProto");
    }
    this.androidManifestProto = androidManifestProto;
    if (resourceTable == null) {
      throw new NullPointerException("Null resourceTable");
    }
    this.resourceTable = resourceTable;
    if (assetsConfig == null) {
      throw new NullPointerException("Null assetsConfig");
    }
    this.assetsConfig = assetsConfig;
    if (nativeConfig == null) {
      throw new NullPointerException("Null nativeConfig");
    }
    this.nativeConfig = nativeConfig;
    if (entryMap == null) {
      throw new NullPointerException("Null entryMap");
    }
    this.entryMap = entryMap;
  }

  @Override
  public BundleModuleName getName() {
    return name;
  }

  @Override
  public Config.BundleConfig getBundleConfig() {
    return bundleConfig;
  }

  @Override
  Resources.XmlNode getAndroidManifestProto() {
    return androidManifestProto;
  }

  @Override
  public Optional<Resources.ResourceTable> getResourceTable() {
    return resourceTable;
  }

  @Override
  public Optional<Files.Assets> getAssetsConfig() {
    return assetsConfig;
  }

  @Override
  public Optional<Files.NativeLibraries> getNativeConfig() {
    return nativeConfig;
  }

  @Override
  ImmutableMap<ZipPath, ModuleEntry> getEntryMap() {
    return entryMap;
  }

  @Override
  public String toString() {
    return "BundleModule{"
        + "name=" + name + ", "
        + "bundleConfig=" + bundleConfig + ", "
        + "androidManifestProto=" + androidManifestProto + ", "
        + "resourceTable=" + resourceTable + ", "
        + "assetsConfig=" + assetsConfig + ", "
        + "nativeConfig=" + nativeConfig + ", "
        + "entryMap=" + entryMap
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof BundleModule) {
      BundleModule that = (BundleModule) o;
      return (this.name.equals(that.getName()))
           && (this.bundleConfig.equals(that.getBundleConfig()))
           && (this.androidManifestProto.equals(that.getAndroidManifestProto()))
           && (this.resourceTable.equals(that.getResourceTable()))
           && (this.assetsConfig.equals(that.getAssetsConfig()))
           && (this.nativeConfig.equals(that.getNativeConfig()))
           && (this.entryMap.equals(that.getEntryMap()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= this.name.hashCode();
    h *= 1000003;
    h ^= this.bundleConfig.hashCode();
    h *= 1000003;
    h ^= this.androidManifestProto.hashCode();
    h *= 1000003;
    h ^= this.resourceTable.hashCode();
    h *= 1000003;
    h ^= this.assetsConfig.hashCode();
    h *= 1000003;
    h ^= this.nativeConfig.hashCode();
    h *= 1000003;
    h ^= this.entryMap.hashCode();
    return h;
  }

  @Override
  BundleModule.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends BundleModule.Builder {
    private BundleModuleName name;
    private Config.BundleConfig bundleConfig;
    private Resources.XmlNode androidManifestProto;
    private Optional<Resources.ResourceTable> resourceTable = Optional.empty();
    private Optional<Files.Assets> assetsConfig = Optional.empty();
    private Optional<Files.NativeLibraries> nativeConfig = Optional.empty();
    private ImmutableMap.Builder<ZipPath, ModuleEntry> entryMapBuilder$;
    private ImmutableMap<ZipPath, ModuleEntry> entryMap;
    Builder() {
    }
    private Builder(BundleModule source) {
      this.name = source.getName();
      this.bundleConfig = source.getBundleConfig();
      this.androidManifestProto = source.getAndroidManifestProto();
      this.resourceTable = source.getResourceTable();
      this.assetsConfig = source.getAssetsConfig();
      this.nativeConfig = source.getNativeConfig();
      this.entryMap = source.getEntryMap();
    }
    @Override
    public BundleModule.Builder setName(BundleModuleName name) {
      if (name == null) {
        throw new NullPointerException("Null name");
      }
      this.name = name;
      return this;
    }
    @Override
    public BundleModule.Builder setBundleConfig(Config.BundleConfig bundleConfig) {
      if (bundleConfig == null) {
        throw new NullPointerException("Null bundleConfig");
      }
      this.bundleConfig = bundleConfig;
      return this;
    }
    @Override
    Config.BundleConfig getBundleConfig() {
      if (bundleConfig == null) {
        throw new IllegalStateException("Property \"bundleConfig\" has not been set");
      }
      return bundleConfig;
    }
    @Override
    BundleModule.Builder setAndroidManifestProto(Resources.XmlNode androidManifestProto) {
      if (androidManifestProto == null) {
        throw new NullPointerException("Null androidManifestProto");
      }
      this.androidManifestProto = androidManifestProto;
      return this;
    }
    @Override
    BundleModule.Builder setResourceTable(Resources.ResourceTable resourceTable) {
      if (resourceTable == null) {
        throw new NullPointerException("Null resourceTable");
      }
      this.resourceTable = Optional.of(resourceTable);
      return this;
    }
    @Override
    BundleModule.Builder setAssetsConfig(Files.Assets assetsConfig) {
      if (assetsConfig == null) {
        throw new NullPointerException("Null assetsConfig");
      }
      this.assetsConfig = Optional.of(assetsConfig);
      return this;
    }
    @Override
    BundleModule.Builder setNativeConfig(Files.NativeLibraries nativeConfig) {
      if (nativeConfig == null) {
        throw new NullPointerException("Null nativeConfig");
      }
      this.nativeConfig = Optional.of(nativeConfig);
      return this;
    }
    @Override
    BundleModule.Builder setEntryMap(ImmutableMap<ZipPath, ModuleEntry> entryMap) {
      if (entryMap == null) {
        throw new NullPointerException("Null entryMap");
      }
      if (entryMapBuilder$ != null) {
        throw new IllegalStateException("Cannot set entryMap after calling entryMapBuilder()");
      }
      this.entryMap = entryMap;
      return this;
    }
    @Override
    ImmutableMap.Builder<ZipPath, ModuleEntry> entryMapBuilder() {
      if (entryMapBuilder$ == null) {
        if (entryMap == null) {
          entryMapBuilder$ = ImmutableMap.builder();
        } else {
          entryMapBuilder$ = ImmutableMap.builder();
          entryMapBuilder$.putAll(entryMap);
          entryMap = null;
        }
      }
      return entryMapBuilder$;
    }
    @Override
    public BundleModule build() {
      if (entryMapBuilder$ != null) {
        this.entryMap = entryMapBuilder$.build();
      } else if (this.entryMap == null) {
        this.entryMap = ImmutableMap.of();
      }
      String missing = "";
      if (this.name == null) {
        missing += " name";
      }
      if (this.bundleConfig == null) {
        missing += " bundleConfig";
      }
      if (this.androidManifestProto == null) {
        missing += " androidManifestProto";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_BundleModule(
          this.name,
          this.bundleConfig,
          this.androidManifestProto,
          this.resourceTable,
          this.assetsConfig,
          this.nativeConfig,
          this.entryMap);
    }
  }

}
