
package com.android.tools.build.bundletool.commands;

import com.google.common.collect.ImmutableSortedSet;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
 final class AutoValue_CommandHelp extends CommandHelp {

  private final String commandName;
  private final CommandHelp.CommandDescription commandDescription;
  private final ImmutableSortedSet<CommandHelp.FlagDescription> flags;

  private AutoValue_CommandHelp(
      String commandName,
      CommandHelp.CommandDescription commandDescription,
      ImmutableSortedSet<CommandHelp.FlagDescription> flags) {
    this.commandName = commandName;
    this.commandDescription = commandDescription;
    this.flags = flags;
  }

  @Override
  String getCommandName() {
    return commandName;
  }

  @Override
  CommandHelp.CommandDescription getCommandDescription() {
    return commandDescription;
  }

  @Override
  ImmutableSortedSet<CommandHelp.FlagDescription> getFlags() {
    return flags;
  }

  @Override
  public String toString() {
    return "CommandHelp{"
        + "commandName=" + commandName + ", "
        + "commandDescription=" + commandDescription + ", "
        + "flags=" + flags
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof CommandHelp) {
      CommandHelp that = (CommandHelp) o;
      return (this.commandName.equals(that.getCommandName()))
           && (this.commandDescription.equals(that.getCommandDescription()))
           && (this.flags.equals(that.getFlags()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= this.commandName.hashCode();
    h *= 1000003;
    h ^= this.commandDescription.hashCode();
    h *= 1000003;
    h ^= this.flags.hashCode();
    return h;
  }

  static final class Builder extends CommandHelp.Builder {
    private String commandName;
    private CommandHelp.CommandDescription commandDescription;
    private ImmutableSortedSet<CommandHelp.FlagDescription> flags;
    Builder() {
    }
    @Override
    public CommandHelp.Builder setCommandName(String commandName) {
      if (commandName == null) {
        throw new NullPointerException("Null commandName");
      }
      this.commandName = commandName;
      return this;
    }
    @Override
    public CommandHelp.Builder setCommandDescription(CommandHelp.CommandDescription commandDescription) {
      if (commandDescription == null) {
        throw new NullPointerException("Null commandDescription");
      }
      this.commandDescription = commandDescription;
      return this;
    }
    @Override
    CommandHelp.Builder setFlags(ImmutableSortedSet<CommandHelp.FlagDescription> flags) {
      if (flags == null) {
        throw new NullPointerException("Null flags");
      }
      this.flags = flags;
      return this;
    }
    @Override
    CommandHelp autoBuild() {
      String missing = "";
      if (this.commandName == null) {
        missing += " commandName";
      }
      if (this.commandDescription == null) {
        missing += " commandDescription";
      }
      if (this.flags == null) {
        missing += " flags";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_CommandHelp(
          this.commandName,
          this.commandDescription,
          this.flags);
    }
  }

}
