/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.commands;

import com.android.bundle.Commands;
import com.android.bundle.Config;
import com.android.bundle.Devices;
import com.android.tools.build.bundletool.commands.AutoValue_ExtractApksCommand;
import com.android.tools.build.bundletool.commands.CommandHelp;
import com.android.tools.build.bundletool.device.ApkMatcher;
import com.android.tools.build.bundletool.device.DeviceSpecParser;
import com.android.tools.build.bundletool.device.LocalTestingPathResolver;
import com.android.tools.build.bundletool.flags.Flag;
import com.android.tools.build.bundletool.flags.ParsedFlags;
import com.android.tools.build.bundletool.model.exceptions.IncompatibleDeviceException;
import com.android.tools.build.bundletool.model.exceptions.InvalidCommandException;
import com.android.tools.build.bundletool.model.utils.ResultUtils;
import com.android.tools.build.bundletool.model.utils.files.FilePreconditions;
import com.android.tools.build.bundletool.model.utils.files.FileUtils;
import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.MoreCollectors;
import com.google.common.io.ByteStreams;
import com.google.protobuf.Int32Value;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

@AutoValue
public abstract class ExtractApksCommand {
    private static final Logger logger = Logger.getLogger(ExtractApksCommand.class.getName());
    public static final String COMMAND_NAME = "extract-apks";
    static final String ALL_MODULES_SHORTCUT = "_ALL_";
    private static final String METADATA_FILE = "metadata.json";
    private static final Flag<Path> APKS_ARCHIVE_FILE_FLAG = Flag.path("apks");
    private static final Flag<Path> DEVICE_SPEC_FLAG = Flag.path("device-spec");
    private static final Flag<Path> OUTPUT_DIRECTORY = Flag.path("output-dir");
    private static final Flag<ImmutableSet<String>> MODULES_FLAG = Flag.stringSet("modules");
    private static final Flag<Boolean> INSTANT_FLAG = Flag.booleanFlag("instant");
    private static final Flag<Boolean> INCLUDE_METADATA_FLAG = Flag.booleanFlag("include-metadata");

    public abstract Path getApksArchivePath();

    public abstract Devices.DeviceSpec getDeviceSpec();

    public abstract Optional<Path> getOutputDirectory();

    public abstract Optional<ImmutableSet<String>> getModules();

    public abstract boolean getInstant();

    public abstract boolean getIncludeMetadata();

    public static Builder builder() {
        return new AutoValue_ExtractApksCommand.Builder().setInstant(false).setIncludeMetadata(false);
    }

    public static ExtractApksCommand fromFlags(ParsedFlags flags) {
        Path apksArchivePath = APKS_ARCHIVE_FILE_FLAG.getRequiredValue(flags);
        Path deviceSpecPath = DEVICE_SPEC_FLAG.getRequiredValue(flags);
        Optional<Path> outputDirectory = OUTPUT_DIRECTORY.getValue(flags);
        Optional<ImmutableSet<String>> modules = MODULES_FLAG.getValue(flags);
        Optional<Boolean> instant = INSTANT_FLAG.getValue(flags);
        Optional<Boolean> includeMetadata = INCLUDE_METADATA_FLAG.getValue(flags);
        flags.checkNoUnknownFlags();
        Builder command = ExtractApksCommand.builder();
        Preconditions.checkArgument((!Files.isDirectory(apksArchivePath, new LinkOption[0]) ? 1 : 0) != 0, (String)"File '%s' is a directory.", (Object)apksArchivePath);
        command.setApksArchivePath(apksArchivePath);
        FilePreconditions.checkFileExistsAndReadable(deviceSpecPath);
        command.setDeviceSpec(DeviceSpecParser.parseDeviceSpec(deviceSpecPath));
        outputDirectory.ifPresent(command::setOutputDirectory);
        modules.ifPresent(command::setModules);
        instant.ifPresent(command::setInstant);
        includeMetadata.ifPresent(command::setIncludeMetadata);
        return command.build();
    }

    public ImmutableList<Path> execute() {
        return this.execute(System.out);
    }

    @VisibleForTesting
    ImmutableList<Path> execute(PrintStream output) {
        this.validateInput();
        Commands.BuildApksResult toc = ResultUtils.readTableOfContents(this.getApksArchivePath());
        Optional<ImmutableSet<String>> requestedModuleNames = this.getModules().map(modules -> ExtractApksCommand.resolveRequestedModules((ImmutableSet<String>)modules, toc));
        Devices.DeviceSpec deviceSpec = ExtractApksCommand.applyDefaultsToDeviceSpec(this.getDeviceSpec(), toc);
        ApkMatcher apkMatcher = new ApkMatcher(deviceSpec, requestedModuleNames, this.getInstant(), true);
        ImmutableList<ApkMatcher.GeneratedApk> generatedApks = apkMatcher.getMatchingApks(toc);
        if (generatedApks.isEmpty()) {
            throw IncompatibleDeviceException.builder().withUserMessage("No compatible APKs found for the device.").build();
        }
        if (Files.isDirectory(this.getApksArchivePath(), new LinkOption[0])) {
            return (ImmutableList)generatedApks.stream().map(matchedApk -> this.getApksArchivePath().resolve(matchedApk.getPath().toString())).collect(ImmutableList.toImmutableList());
        }
        return this.extractMatchedApksFromApksArchive(generatedApks, toc);
    }

    static ImmutableSet<String> resolveRequestedModules(ImmutableSet<String> requestedModules, Commands.BuildApksResult toc) {
        return requestedModules.contains((Object)ALL_MODULES_SHORTCUT) ? (ImmutableSet)Stream.concat(toc.getVariantList().stream().flatMap(variant -> variant.getApkSetList().stream()).map(apkSet -> apkSet.getModuleMetadata().getName()), toc.getAssetSliceSetList().stream().map(Commands.AssetSliceSet::getAssetModuleMetadata).map(Commands.AssetModuleMetadata::getName)).collect(ImmutableSet.toImmutableSet()) : requestedModules;
    }

    private void validateInput() {
        if (this.getModules().isPresent() && this.getModules().get().isEmpty()) {
            throw InvalidCommandException.builder().withInternalMessage("The set of modules cannot be empty.").build();
        }
        if (Files.isDirectory(this.getApksArchivePath(), new LinkOption[0])) {
            Preconditions.checkArgument((!this.getOutputDirectory().isPresent() ? 1 : 0) != 0, (Object)"Output directory should not be set when APKs are inside directory.");
            FilePreconditions.checkDirectoryExists(this.getApksArchivePath());
            FilePreconditions.checkFileExistsAndReadable(this.getApksArchivePath().resolve("toc.pb"));
        } else {
            FilePreconditions.checkFileExistsAndReadable(this.getApksArchivePath());
        }
    }

    private ImmutableList<Path> extractMatchedApksFromApksArchive(ImmutableList<ApkMatcher.GeneratedApk> generatedApks, Commands.BuildApksResult toc) {
        Path outputDirectoryPath = this.getOutputDirectory().orElseGet(ExtractApksCommand::createTempDirectory);
        this.getOutputDirectory().ifPresent(dir -> {
            if (!Files.exists(dir, new LinkOption[0])) {
                logger.info("Output directory '" + dir + "' does not exist, creating it.");
                FileUtils.createDirectories(dir);
            }
        });
        ImmutableList.Builder builder = ImmutableList.builder();
        try (ZipFile apksArchive = new ZipFile(this.getApksArchivePath().toFile());){
            for (ApkMatcher.GeneratedApk matchedApk : generatedApks) {
                ZipEntry entry = apksArchive.getEntry(matchedApk.getPath().toString());
                Preconditions.checkNotNull((Object)entry);
                Path extractedApkPath = outputDirectoryPath.resolve(matchedApk.getPath().getFileName().toString());
                try {
                    InputStream inputStream = apksArchive.getInputStream(entry);
                    Throwable throwable = null;
                    try {
                        OutputStream outputApk = Files.newOutputStream(extractedApkPath, new OpenOption[0]);
                        Throwable throwable2 = null;
                        try {
                            ByteStreams.copy((InputStream)inputStream, (OutputStream)outputApk);
                            builder.add((Object)extractedApkPath);
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (outputApk == null) continue;
                            if (throwable2 != null) {
                                try {
                                    outputApk.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                continue;
                            }
                            outputApk.close();
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (inputStream == null) continue;
                        if (throwable != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                            continue;
                        }
                        inputStream.close();
                    }
                }
                catch (IOException e11) {
                    throw new UncheckedIOException(String.format("Error while extracting APK '%s' from the APK Set.", matchedApk), e11);
                }
            }
            if (this.getIncludeMetadata()) {
                ExtractApksCommand.produceCommandMetadata(generatedApks, toc, outputDirectoryPath);
            }
        }
        catch (IOException e12) {
            throw new UncheckedIOException(String.format("Error while processing the APK Set archive '%s'.", this.getApksArchivePath()), e12);
        }
        System.err.printf("The APKs have been extracted in the directory: %s%n", outputDirectoryPath.toString());
        return builder.build();
    }

    private static void produceCommandMetadata(ImmutableList<ApkMatcher.GeneratedApk> generatedApks, Commands.BuildApksResult toc, Path outputDir) {
        ImmutableList apks = (ImmutableList)generatedApks.stream().map(apk -> Commands.ExtractedApk.newBuilder().setPath(apk.getPath().getFileName().toString()).setModuleName(apk.getModuleName()).setDeliveryType(apk.getDeliveryType()).build()).collect(ImmutableList.toImmutableList());
        try {
            JsonFormat.Printer printer = JsonFormat.printer();
            Commands.ExtractApksResult.Builder builder = Commands.ExtractApksResult.newBuilder();
            if (toc.getLocalTestingInfo().getEnabled()) {
                builder.setLocalTestingInfo(ExtractApksCommand.createLocalTestingInfo(toc));
            }
            String metadata = printer.print((MessageOrBuilder)builder.addAllApks((Iterable<? extends Commands.ExtractedApk>)apks).build());
            Files.write(outputDir.resolve(METADATA_FILE), metadata.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e11) {
            throw new UncheckedIOException("Error while writing metadata.json.", e11);
        }
    }

    private static Commands.LocalTestingInfoForMetadata createLocalTestingInfo(Commands.BuildApksResult toc) {
        String localTestingPath = toc.getLocalTestingInfo().getLocalTestingPath();
        String packageName = toc.getPackageName();
        return Commands.LocalTestingInfoForMetadata.newBuilder().setLocalTestingDir(LocalTestingPathResolver.resolveLocalTestingPath(localTestingPath, Optional.of(packageName))).build();
    }

    private static Path createTempDirectory() {
        try {
            return Files.createTempDirectory("bundletool-extracted-apks", new FileAttribute[0]);
        }
        catch (IOException e11) {
            throw new UncheckedIOException("Unable to create a temporary directory for extracted APKs.", e11);
        }
    }

    private static Devices.DeviceSpec applyDefaultsToDeviceSpec(Devices.DeviceSpec deviceSpec, Commands.BuildApksResult toc) {
        if (deviceSpec.hasDeviceTier()) {
            return deviceSpec;
        }
        int defaultDeviceTier = ((Optional)toc.getDefaultTargetingValueList().stream().filter(defaultTargetingValue -> defaultTargetingValue.getDimension().equals((Object)Config.SplitDimension.Value.DEVICE_TIER)).map(Commands.DefaultTargetingValue::getDefaultValue).filter(defaultValue -> !defaultValue.isEmpty()).map(Integer::parseInt).collect(MoreCollectors.toOptional())).orElse(0);
        return deviceSpec.toBuilder().setDeviceTier(Int32Value.of((int)defaultDeviceTier)).build();
    }

    public static CommandHelp help() {
        return CommandHelp.builder().setCommandName(COMMAND_NAME).setCommandDescription(CommandHelp.CommandDescription.builder().setShortDescription("Extracts from an APK Set the APKs that should be installed on a given device.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(APKS_ARCHIVE_FILE_FLAG.getName()).setExampleValue("archive.apks").setDescription("Path to the archive file generated by the '%s' command.", "build-apks").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(DEVICE_SPEC_FLAG.getName()).setExampleValue("device-spec.json").setDescription("Path to the device spec file generated by the '%s' command.", "get-device-spec").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(OUTPUT_DIRECTORY.getName()).setOptional(true).setExampleValue("output-dir").setDescription("Path to where the matched APKs will be extracted from the archive file. If not set, the APK Set archive is created in a temporary directory.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(MODULES_FLAG.getName()).setExampleValue("base,module1,module2").setOptional(true).setDescription("List of modules to be extracted, or \"%s\" for all modules. Defaults to modules installed during the first install, i.e. not on-demand. Note that the dependent modules will also be extracted. The value of this flag is ignored if the device receives a standalone APK.", ALL_MODULES_SHORTCUT).build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(INSTANT_FLAG.getName()).setOptional(true).setDescription("When set, APKs of the instant modules will be extracted instead of the installable APKs.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(INCLUDE_METADATA_FLAG.getName()).setOptional(true).setDescription("When set, metadata.json will be produced to the output directory with description about extracted APKs.").build()).build();
    }

    ExtractApksCommand() {
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setApksArchivePath(Path var1);

        public abstract Builder setDeviceSpec(Devices.DeviceSpec var1);

        public Builder setDeviceSpec(Path deviceSpecPath) {
            return this.setDeviceSpec(DeviceSpecParser.parseDeviceSpec(deviceSpecPath));
        }

        public abstract Builder setOutputDirectory(Path var1);

        public abstract Builder setModules(ImmutableSet<String> var1);

        public abstract Builder setInstant(boolean var1);

        public abstract Builder setIncludeMetadata(boolean var1);

        abstract ExtractApksCommand autoBuild();

        public ExtractApksCommand build() {
            ExtractApksCommand command = this.autoBuild();
            DeviceSpecParser.validateDeviceSpec(command.getDeviceSpec(), true);
            return command;
        }
    }
}

