/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.io;

import com.android.tools.build.bundletool.io.ZipBuilder;
import com.android.tools.build.bundletool.model.SdkAsar;
import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.xml.XmlUtils;
import com.google.common.io.ByteSource;
import com.google.protobuf.MessageLite;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;

public class SdkAsarSerializer {
    public static void writeToDisk(SdkAsar asar, Path pathOnDisk) throws IOException {
        ZipBuilder zipBuilder = new ZipBuilder();
        zipBuilder.addFile(ZipPath.create("AndroidManifest.xml"), ByteSource.wrap((byte[])XmlUtils.documentToString(asar.getManifest()).getBytes(StandardCharsets.UTF_8)), new ZipBuilder.EntryOption[0]);
        zipBuilder.addFileFromDisk(ZipPath.create("modules.resm"), asar.getModulesFile(), new ZipBuilder.EntryOption[0]);
        zipBuilder.addFileWithProtoContent(ZipPath.create("SdkMetadata.pb"), (MessageLite)asar.getSdkMetadata(), new ZipBuilder.EntryOption[0]);
        zipBuilder.writeTo(pathOnDisk);
    }

    private SdkAsarSerializer() {
    }
}

