/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model;

import com.android.bundle.Config;
import com.android.bundle.Files;
import com.android.bundle.RuntimeEnabledSdkConfigProto;
import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.model.AutoValue_AppBundle;
import com.android.tools.build.bundletool.model.Bundle;
import com.android.tools.build.bundletool.model.BundleMetadata;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.BundleModuleName;
import com.android.tools.build.bundletool.model.ResourceId;
import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.model.exceptions.InvalidBundleException;
import com.android.tools.build.bundletool.model.utils.BundleParser;
import com.android.tools.build.bundletool.model.version.Version;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.MoreCollectors;
import com.google.errorprone.annotations.Immutable;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.zip.ZipFile;

@Immutable
@AutoValue
public abstract class AppBundle
implements Bundle {
    public static final ZipPath METADATA_DIRECTORY = ZipPath.create("BUNDLE-METADATA");
    public static final String BUNDLE_CONFIG_FILE_NAME = "BundleConfig.pb";
    public static final ImmutableSet<ZipPath> NON_MODULE_DIRECTORIES = ImmutableSet.of((Object)METADATA_DIRECTORY, (Object)ZipPath.create("META-INF"));

    public static AppBundle buildFromZip(ZipFile bundleFile) {
        Config.BundleConfig bundleConfig = BundleParser.readBundleConfig(bundleFile);
        Optional<Config.ApexConfig> apexConfig = bundleConfig.hasApexConfig() ? Optional.of(bundleConfig.getApexConfig()) : Optional.empty();
        return AppBundle.buildFromModules(BundleParser.sanitize(BundleParser.extractModules(bundleFile, bundleConfig.getType(), Version.of(bundleConfig.getBundletool().getVersion()), apexConfig, NON_MODULE_DIRECTORIES)), bundleConfig, BundleParser.readBundleMetadata(bundleFile));
    }

    public static AppBundle buildFromModules(ImmutableList<BundleModule> modules, Config.BundleConfig bundleConfig, BundleMetadata bundleMetadata) {
        ImmutableSet pinnedResourceIds = (ImmutableSet)bundleConfig.getMasterResources().getResourceIdsList().stream().map(ResourceId::create).collect(ImmutableSet.toImmutableSet());
        ImmutableSet pinnedResourceNames = ImmutableSet.copyOf((Collection)bundleConfig.getMasterResources().getResourceNamesList());
        ImmutableListMultimap runtimeEnabledSdkDependencies = (ImmutableListMultimap)modules.stream().filter(module -> module.getRuntimeEnabledSdkConfig().isPresent()).map(module -> module.getRuntimeEnabledSdkConfig().get()).flatMap(runtimeEnabledSdkConfig -> runtimeEnabledSdkConfig.getRuntimeEnabledSdkList().stream()).collect(ImmutableListMultimap.toImmutableListMultimap(RuntimeEnabledSdkConfigProto.RuntimeEnabledSdk::getPackageName, Function.identity()));
        AppBundle.validateUniqueSdkDependencies((ImmutableListMultimap<String, RuntimeEnabledSdkConfigProto.RuntimeEnabledSdk>)runtimeEnabledSdkDependencies);
        return AppBundle.builder().setModules((ImmutableMap<BundleModuleName, BundleModule>)Maps.uniqueIndex(modules, BundleModule::getName)).setMasterPinnedResourceIds((ImmutableSet<ResourceId>)pinnedResourceIds).setMasterPinnedResourceNames((ImmutableSet<String>)pinnedResourceNames).setBundleConfig(bundleConfig).setBundleMetadata(bundleMetadata).setRuntimeEnabledSdkDependencies((ImmutableMap<String, RuntimeEnabledSdkConfigProto.RuntimeEnabledSdk>)((ImmutableMap)runtimeEnabledSdkDependencies.values().stream().collect(ImmutableMap.toImmutableMap(RuntimeEnabledSdkConfigProto.RuntimeEnabledSdk::getPackageName, Function.identity())))).build();
    }

    public abstract ImmutableMap<BundleModuleName, BundleModule> getModules();

    public abstract ImmutableSet<ResourceId> getMasterPinnedResourceIds();

    public abstract ImmutableSet<String> getMasterPinnedResourceNames();

    public abstract Config.BundleConfig getBundleConfig();

    @Override
    public abstract BundleMetadata getBundleMetadata();

    public abstract ImmutableMap<String, RuntimeEnabledSdkConfigProto.RuntimeEnabledSdk> getRuntimeEnabledSdkDependencies();

    public ImmutableMap<BundleModuleName, BundleModule> getFeatureModules() {
        return (ImmutableMap)this.getModules().values().stream().filter(module -> module.getModuleType().isFeatureModule()).collect(ImmutableMap.toImmutableMap(BundleModule::getName, Function.identity()));
    }

    public ImmutableMap<BundleModuleName, BundleModule> getAssetModules() {
        return (ImmutableMap)this.getModules().values().stream().filter(module -> module.getModuleType().equals((Object)BundleModule.ModuleType.ASSET_MODULE)).collect(ImmutableMap.toImmutableMap(BundleModule::getName, Function.identity()));
    }

    public BundleModule getBaseModule() {
        return this.getModule(BundleModuleName.BASE_MODULE_NAME);
    }

    public boolean hasBaseModule() {
        return this.getModules().containsKey((Object)BundleModuleName.BASE_MODULE_NAME);
    }

    @Override
    public String getPackageName() {
        if (this.isAssetOnly()) {
            return (String)this.getModules().values().stream().map(module -> module.getAndroidManifest().getPackageName()).distinct().collect(MoreCollectors.onlyElement());
        }
        return this.getBaseModule().getAndroidManifest().getPackageName();
    }

    @Override
    public BundleModule getModule(BundleModuleName moduleName) {
        BundleModule module = (BundleModule)this.getModules().get((Object)moduleName);
        Preconditions.checkState((module != null ? 1 : 0) != 0, (String)"Module '%s' not found.", (Object)moduleName);
        return module;
    }

    public Version getVersion() {
        return Version.of(this.getBundleConfig().getBundletool().getVersion());
    }

    public ImmutableSet<Targeting.Abi> getTargetedAbis() {
        return (ImmutableSet)this.getFeatureModules().values().stream().map(BundleModule::getNativeConfig).flatMap(nativeConfig -> {
            if (nativeConfig.isPresent()) {
                return ((Files.NativeLibraries)nativeConfig.get()).getDirectoryList().stream().map(Files.TargetedNativeDirectory::getTargeting).map(Targeting.NativeDirectoryTargeting::getAbi);
            }
            return Stream.empty();
        }).distinct().collect(ImmutableSet.toImmutableSet());
    }

    public boolean isApex() {
        return !this.isAssetOnly() && this.getBaseModule().getApexConfig().isPresent();
    }

    public boolean isAssetOnly() {
        return this.getBundleConfig().getType().equals((Object)Config.BundleConfig.BundleType.ASSET_ONLY);
    }

    public boolean hasSharedUserId() {
        return this.getBaseModule().getAndroidManifest().hasSharedUserId();
    }

    public boolean dexMergingEnabled() {
        return this.getDexMergingStrategy().equals((Object)Config.StandaloneConfig.DexMergingStrategy.MERGE_IF_NEEDED) && this.getBaseModule().getAndroidManifest().getEffectiveMinSdkVersion() < 21 && this.getFeatureModules().size() > 1;
    }

    private Config.StandaloneConfig.DexMergingStrategy getDexMergingStrategy() {
        return this.getBundleConfig().getOptimizations().getStandaloneConfig().getDexMergingStrategy();
    }

    public Optional<Boolean> getStoreArchive() {
        return this.getBundleConfig().getOptimizations().hasStoreArchive() ? Optional.of(this.getBundleConfig().getOptimizations().getStoreArchive().getEnabled()) : Optional.empty();
    }

    public boolean injectLocaleConfig() {
        return this.getBundleConfig().getLocales().getInjectLocaleConfig();
    }

    public abstract Builder toBuilder();

    static Builder builder() {
        return new AutoValue_AppBundle.Builder().setRuntimeEnabledSdkDependencies((ImmutableMap<String, RuntimeEnabledSdkConfigProto.RuntimeEnabledSdk>)ImmutableMap.of());
    }

    private static void validateUniqueSdkDependencies(ImmutableListMultimap<String, RuntimeEnabledSdkConfigProto.RuntimeEnabledSdk> runtimeEnabledSdkDependencies) {
        runtimeEnabledSdkDependencies.keySet().forEach(sdkPackageName -> {
            if (runtimeEnabledSdkDependencies.get(sdkPackageName).size() > 1) {
                throw InvalidBundleException.builder().withUserMessage("Found multiple dependencies on the same runtime-enabled SDK '%s'.", sdkPackageName).build();
            }
        });
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setModules(ImmutableMap<BundleModuleName, BundleModule> var1);

        public Builder setRawModules(Collection<BundleModule> bundleModules) {
            this.setModules((ImmutableMap<BundleModuleName, BundleModule>)((ImmutableMap)bundleModules.stream().collect(ImmutableMap.toImmutableMap(BundleModule::getName, Function.identity()))));
            return this;
        }

        public Builder addRawModules(Collection<BundleModule> bundleModules) {
            this.modulesBuilder().putAll((Map)bundleModules.stream().collect(ImmutableMap.toImmutableMap(BundleModule::getName, Function.identity())));
            return this;
        }

        public abstract Builder setMasterPinnedResourceIds(ImmutableSet<ResourceId> var1);

        public abstract Builder setMasterPinnedResourceNames(ImmutableSet<String> var1);

        public abstract Builder setBundleConfig(Config.BundleConfig var1);

        public abstract Builder setBundleMetadata(BundleMetadata var1);

        public abstract Builder setRuntimeEnabledSdkDependencies(ImmutableMap<String, RuntimeEnabledSdkConfigProto.RuntimeEnabledSdk> var1);

        public abstract AppBundle build();

        abstract ImmutableMap.Builder<BundleModuleName, BundleModule> modulesBuilder();
    }
}

